package CatalogDocument;

sub new
{
  my $class = shift;
  my $self  = {};
  bless $self, $class;

  $self->{url} = '';
  $self->{lang} = '';
  $self->{pubdate}->{year} = '';
  $self->{pubdate}->{month} = '';
  $self->{pubdate}->{day} = '';
  $self->{moddate}->{year} = '';
  $self->{moddate}->{month} = '';
  $self->{moddate}->{day} = '';
  $self->{title} = '';
  $self->{summary} = '';
  $self->{category} = '';
  @{$self->{channels}} = ();
  @{$self->{authnames}} = ();

  return $self;
}


sub addChannel
{
  my $self = shift;
  my $channelid = shift;

  push @{$self->{channels}}, $channelid;
}

sub getChannelIds
{
  my $self = shift;
  my $result = '';

  if (@{$self->{channels}} > 0)
  {
    $result = join ",",  @{$self->{channels}};
  }
  return $result;
}

sub addAuthor
{
  my $self = shift;
  my $authname = shift;

  push @{$self->{authnames}}, $authname;
}

sub dump
{
  my $self = shift;
  print 
  "(" .
  'url => ' . $self->{url} . 
  ', ' .
  'lang => ' . $self->{lang} . 
  ', ' .
  'pubdate =>' . 
  '(' .
  $self->{pubdate}->{year} . 
  ', ' .
  $self->{pubdate}->{month} . 
  ', ' .
  $self->{pubdate}->{day} . 
  '), ' .
  'moddate => (' .
  $self->{moddate}->{year} .
  ', ' .
  $self->{moddate}->{month} .
  ', ' .
  $self->{moddate}->{day} .
  '), ' .
  'title => ' .
  $self->{title} .
  ', ' .
  'category => ' .
  $self->{category} .
  ', ' .
  'summary => ' .
  $self->{summary} .
  ', ' .
  'channels => (';
         
  foreach my $channel (@{$self->{channels}})
  {
    print $channel, ', ';
  }
  print ')';

  print ', ';

  print 'authnames => (';
  
  foreach my $authname (@{$self->{authnames}})
  {
    print $authname, ', ';
  }
  print ')';

  if ($self->{obsolete})
  {
    print 'obsolete => ( url =>' . $self->{obsolete}->{url} . ', ' .
                       ' title => ' . $self->{obsolete}->{title} . ', ' .
                       ' message => ' . $self->{obsolete}->{message} .
                       ')';
  }
  print ")\n";
}

1;

