#!/usr/local/bin/perl
#
# $Id: clean-web.pl,v 1.4 2003/09/14 20:52:05 bc Exp $
#
# ***** BEGIN LICENSE BLOCK *****
# Version: MPL 1.1/GPL 2.0/LGPL 2.1
# 
# The contents of this file are subject to the Mozilla Public License Version 
# 1.1 (the "License"); you may not use this file except in compliance with 
# the License. You may obtain a copy of the License at 
# http://www.mozilla.org/MPL/
# 
# Software distributed under the License is distributed on an "AS IS" basis,
# WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
# for the specific language governing rights and limitations under the
# License.
# 
# The Original Code is Netscape code.
#
# The Initial Developer of the Original Code is
# Netscape Corporation.
# Portions created by the Initial Developer are Copyright (C) 2001
# the Initial Developer. All Rights Reserved.
#
# Contributor(s): Bob Clary <bclary@netscape.com>
# Contributor(s): Bob Clary <http://bclary.com>
# 
# Alternatively, the contents of this file may be used under the terms of
# either the GNU General Public License Version 2 or later (the "GPL"), or
# the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
# in which case the provisions of the GPL or the LGPL are applicable instead
# of those above. If you wish to allow use of your version of this file only
# under the terms of either the GPL or the LGPL, and not to allow others to
# use your version of this file under the terms of the MPL, indicate your
# decision by deleting the provisions above and replace them with the notice
# and other provisions required by the GPL or the LGPL. If you do not delete
# the provisions above, a recipient may use your version of this file under
# the terms of any one of the MPL, the GPL or the LGPL.
# 
# ***** END LICENSE BLOCK *****
# usage 
# perl clean-web.pl MAKEPROG SRCEPHYSDIR
#
# clean a Build Web Project by executing make clean on all Makefile.pre and 
# Makefile.post files found in the source directory tree.
#
#
use File::Copy;
use File::Basename;
use Cwd;

# Global Variables

# set $DEBUG to 1 to turn on verbose debugging messages
# set $DEBUG to 0 to turn off verbose debugging messages
my $DEBUG = 0;
my $CLEAN = 1;
# @DEBUGSTACK is used by pushDEBUG and popDEBUG to set local
# debugging values.
my @DEBUGSTACK = (); 

if ($ENV{DEBUG})
{
  $DEBUG=$ENV{DEBUG};
}

die "usage clean-web.pl \"makeprog\" \"srcephysdir\"\n" if ($#ARGV != 1);

my $MAKEPROG    = shift;
my $SRCEPHYSDIR = shift;

# remove trailing / from source, destination directory names
if (substr($SRCEPHYSDIR, length($SRCEPHYSDIR)-1, 1) eq '/')
{
  chop $SRCEPHYSDIR;
}

die "source dir $SRCEPHYSDIR is not a directory" if (! -d $SRCEPHYSDIR);

build_srce_dirlist($SRCEPHYSDIR);

exit(0);

#
# End program
#

sub build_srce_dirlist
{
  # Load the directory and file names from the Source
  # that are to be copied to Destination
  my $currpath = shift;

  _build_srce_dirlist($currpath);
}

sub _build_srce_dirlist
{
  my $currpath = shift;

  debug_msg("_build_srce_dirlist(\"$currpath\")");

  if (-e "$currpath/Makefile.pre")
  {
    debug_msg("_build_srce_dirlist PRE Make path=$currpath");
    system("$MAKEPROG -C $currpath -f Makefile.pre clean > $currpath/Makefile.pre.log 2>&1") == 0 or die "make $currpath/Makefile.pre failed\n";
  }

  if (-e "$currpath/Makefile.post")
  {
    debug_msg("_build_srce_dirlist POST Make currpath=$currpath");
    system("$MAKEPROG -C $currpath -f Makefile.post clean > $currpath/Makefile.post.log 2>&1") == 0 or die "make $currpath/Makefile.post failed\n";
  }

  my $entry;

  # Load Directory Names
  if (!opendir(DIRH, $currpath))
  {
    warn "unable to open directory $currpath, $!\n";
    return;
  }
  my @tempdirlist = grep -d, map "$currpath/$_", readdir DIRH;
  closedir DIRH;

  foreach $entry (@tempdirlist)
  {
    if ($entry =~ /(\.\.?|CVS|_vti_[^\/]*)$/) 
    {
      ; # Skip ., .., any CVS or FrontPage directories
    }
    else
    {
      _build_srce_dirlist($entry);
    }
  }
}

#
# debugging stuff
#
sub debug_msg 
{
  # print a debug message to STDOUT

  print "DEBUG: $_[0]\n" if ($DEBUG);
}

sub pushDEBUG
{
  push @DEBUGSTACK, $DEBUG;
  $DEBUG = 1;
}

sub popDEBUG
{
  $DEBUG = pop @DEBUGSTACK;
}

sub dump_loc
{
  if ($DEBUG)
  {
    my $locref = shift;
  
    print "\n== dirlist ==\n";
    print join "\n", @{$$locref{dirlist}};
    print "\n== filelist ==\n";
    print join "\n", @{$$locref{filelist}};
  }
}

# eof: clean-web.pl
