# build-web makefile variables.
# bclary 2001-10-18
#
# These variables assume you have created an environment such as
#
# build-web
# build-web/bin (perl scripts and other common files)
# build-web/<<project>> (where <<project>> is specific to your web project)
# build-web/<<project>>/srce (raw source for web project)
# build-web/<<project>>/dest-prod (output for production web project)
# build-web/<<project>>/dest-dev (output for devopment web project)
# build-web/<<project>>/dirmap-prod.pl (production directory map)
# build-web/<<project>>/dirmap-dev.pl (development directory map)
#
BIN         ?= $(BUILD_WEB_DIR)/bin
PERL        ?= perl -w
RM          ?= rm -f
TMPDIR      ?= /tmp
#
#
MAKEPROG    ?= make
SRCEPHYSDIR ?= srce
BUILDTYPE   ?= dev
COPY        ?= on
CLEAN       ?= off
SSIPROCESS  ?= on

DIRMAP ?= dirmap-$(BUILDTYPE).pl
DESTPHYSDIR ?= dest-$(BUILDTYPE)

default:: all

main:
	$(PERL) $(BIN)/build-web.pl \
		--make=$(MAKE) \
		--srcephysdir=$(SRCEPHYSDIR) \
		--copy=$(COPY) \
		--clean=$(CLEAN) \
		--ssiprocess=$(SSIPROCESS) \
		--dirmap=$(DIRMAP) \
		--srcewebdir=$(SRCEWEBDIR) \
		--destphysdir=$(DESTPHYSDIR) 
		touch $(SRCEPHYSDIR)/timestamp

clean-main:
	$(RM) -R  $(DESTPHYSDIR)/*
	$(RM) $(SRCEPHYSDIR)/timestamp
	$(PERL) $(BIN)/clean-web.pl $(MAKE) $(SRCEPHYSDIR) 


