// used with /lib/include/prev-next-nav-incl.html
// to provide a series of prev/next links for subsection links

// assumes the following order wrt chapters,sections,subsections
// chapter
//   section
//     subsection
//     subsection
//   section
//     subsection
//     subsection

function makeLink(url, text)
{
  if (!document.createElement || !document.createTextNode)
    return;

  var a = document.createElement('a');
  a.href = url;
  if (a.appendChild)
    a.appendChild(document.createTextNode(text));

  return a;
}

function footerNav()
{
  if (!document.getElementById || !document.getElementsByTagName || !document.createTextNode)
    return;

  var i;
  var rel;
  var found = -1;
  var prevlink = null;
  var thislink = null;
  var nextlink = null;
  var linklist = document.getElementsByTagName('link');
  var lochref  = location.href;

  if (lochref.charAt(lochref.length-1) == '/')
    lochref += lochref + 'index.html';

  for (i = 0; found == -1 && i < linklist.length; ++i)
  {
    thislink = linklist[i];
    rel = thislink.rel.toLowerCase();
    if ('chapter,section,subsection'.indexOf(rel) != -1)
    {
      if (lochref.match(thislink.href))
      {
        found = i;
      }
    }
  }

  if (found == -1)
    return;

  if (found > 0 && 'chapter,section,subsection'.indexOf(linklist[found-1].rel) != -1)
     prevlink = linklist[found-1];

  if (found < linklist.length - 1 && 'chapter,section,subsection'.indexOf(linklist[found+1].rel) != -1)
     nextlink = linklist[found+1];

  var linknav  = document.getElementById('linknav');
  var prevcell = document.getElementById('linknavleft');
  if (prevcell && prevlink)
  {
    if (prevcell.firstChild)
      prevcell.replaceChild(makeLink(prevlink.href, 'Previous ' + prevlink.title), prevcell.firstChild);
    else
      prevcell.appendChild(makeLink(prevlink.href, 'Previous ' + prevlink.title));
  }

  var nextcell = document.getElementById('linknavright');
  if (nextcell && nextlink)
  {
    if (nextcell.firstChild)
      nextcell.replaceChild(makeLink(nextlink.href, 'Next ' + nextlink.title), nextcell.firstChild);
    else
      nextcell.appendChild(makeLink(nextlink.href, 'Next ' + nextlink.title));
  }

  if (linknav && (prevlink || nextlink))
     linknav.style.display='block';

  if (prevcell)
    prevcell.setAttribute('align', 'left');

  if (nextcell)
    nextcell.setAttribute('align', 'right');
}

function tocNav()
{
  if (!document.getElementById || !document.getElementsByTagName || !document.createTextNode)
    return;

  var i;
  var rel;
  var prevrel = '';
  var link = null;
  var linklist = document.getElementsByTagName('link');

  // chapter level of toc
  var chapterul  = document.getElementById('tocnav');
  var chapterli;

  // section level of toc
  var sectionul;
  var sectionli;

  // subsection level of toc
  var subsectionul;
  var subsectionli;

  // link 
  var a;

  for (i = 0; i < linklist.length; ++i)
  {
    link = linklist[i];
    rel  = link.rel.toLowerCase();
    
    switch(rel)
    {
      case 'chapter':
      case 'contents':
      case 'copyright':
      case 'glossary':
      case 'index':
      case 'appendix':
        chapterli  = chapterul.appendChild(document.createElement('li'));
        a          = chapterli.appendChild(document.createElement('a'));
        a.href     = link.href;
        a.appendChild(document.createTextNode(link.title));
        break;

      case 'section':
        switch(prevrel)
        {
        case 'chapter':
        case 'appendix':
          // start a new sequence of sections
          sectionul = chapterli.appendChild(document.createElement('ul'));
          // fall through
        case 'section':
        case 'subsection':
          sectionli  = sectionul.appendChild(document.createElement('li'));
          a          = sectionli.appendChild(document.createElement('a'));
          a.href     = link.href;
          a.appendChild(document.createTextNode(link.title));
          break;
        default:
          break;
        }
        break;

      case 'subsection':
        switch(prevrel)
        {
        case 'section':
          // start a new sequence of subsections
          subsectionul = sectionli.appendChild(document.createElement('ul'));
          // fall through
        case 'subsection':
          subsectionli = subsectionul.appendChild(document.createElement('li'));
          a            = subsectionli.appendChild(document.createElement('a'));
          a.href       = link.href;
          a.appendChild(document.createTextNode(link.title));
          break;
        default:
          break;
        }
        break;

      default:
        break;
    }
    prevrel = rel;
  }
}
