// Mouse Event Functions
// mouse events for the Drag object and Scroll2 object
// 19991007

// Copyright (C) 1999 Dan Steinman
// Distributed under the terms of the GNU Library General Public License
// Available at http://www.dansteinman.com/dynapi/

// updated 20011228 by Bob Clary <http://bclary.com/>
// to support Gecko

function initMouseEvents() {
	document.onmousedown = mouseDown
	document.onmousemove = mouseMove
	document.onmouseup = mouseUp
  //bc:document.captureEvents works in Gecko but not for any other element
	if (is.ns) document.captureEvents(Event.MOUSEDOWN | Event.MOUSEMOVE | Event.MOUSEUP)
}
//bc:
function bcGetMouseX(e)
{
  var x = 0;

  if (is.ns4)
    x = e.pageX;
  else if (is.ie)
    x = event.x + document.body.scrollLeft;
  else if (is.ns5)
    x = e.clientX;

  return x;
}
function bcGetMouseY(e)
{
  var y = 0;

  if (is.ns4)
    y = e.pageY;
  else if (is.ie)
    y = event.y + document.body.scrollTop;
  else if (is.ns5)
    y = e.clientY;

  return y;
}

function mouseDown(e) {
	if ((is.ns && e.which!=1) || (is.ie && event.button!=1)) return true
	//bc:var x = (is.ns)? e.pageX : event.x+document.body.scrollLeft
	//bc:var y = (is.ns)? e.pageY : event.y+document.body.scrollTop
  x = bcGetMouseX(e);
  y = bcGetMouseY(e);
	if (is.ns && e.target!=document) routeEvent(e)
	if (Scroll && ScrollTestActive()) return false
	else if (Drag && drag.mouseDown(x,y)) return false
	else return DynMouseDown(x,y)
}
function mouseMove(e) {
	//bc:var x = (is.ns)? e.pageX : event.x+document.body.scrollLeft
	//bc:var y = (is.ns)? e.pageY : event.y+document.body.scrollTop
  x = bcGetMouseX(e);
  y = bcGetMouseY(e);
	if (is.ns && e.target!=document) routeEvent(e)
	if (Scroll && ScrollTestActive()) return false
	else if (Drag && drag.mouseMove(x,y)) return false
	else return DynMouseMove(x,y)
}
function mouseUp(e) {
	//bc:var x = (is.ns)? e.pageX : event.x+document.body.scrollLeft
	//bc:var y = (is.ns)? e.pageY : event.y+document.body.scrollTop
  x = bcGetMouseX(e);
  y = bcGetMouseY(e);
	if (is.ns && e.target!=document) routeEvent(e)
	if (Drag && drag.mouseUp(x,y)) return false
	else return DynMouseUp(x,y)
}

// overwrite these functions in your html source to do other mouse handling
function DynMouseDown(x,y) {return true}
function DynMouseMove(x,y) {return true}
function DynMouseUp(x,y) {return true}

// include drag.js and/or scroll2.js after this file to overwrite these variables
Drag = null
Scroll = null
