// SimpleAPI
// set of functions for easily manipulating layers, a simple alternative to using the DynLayer
// 19990326

// Copyright (C) 1999 Dan Steinman
// Distributed under the terms of the GNU Library General Public License
// Available at http://www.dansteinman.com/dynapi/

// updated 20011228 by Bob Clary <http://bclary.com/>
// to support Gecko

// warning: these have not been test, please email me a fix if there's any problems

// get the style object reference
function getObject(id,nestref) {
	//bc:if (is.ns) return (nestref)? eval('document.'+nestref+'.document.'+id+'.document') : document.layers[id].document
	if (is.ns4) return (nestref)? eval('document.'+nestref+'.document.'+id+'.document') : document.layers[id].document
	if (is.ie) return document.all[id].style
  //bc:
	if (is.ns5) return document.getElementById(id).style
}

// get the element object reference
function getElement(id,nestref) {
	//bc:if (is.ns) return getObject(id,nestref)
	if (is.ns4) return getObject(id,nestref)
	if (is.ie) return document.all[id]
  //bc:
	if (is.ns5) return document.getElementById(id)
}

// show and hide functions
function show(obj) {
	//bc:if (is.ns) obj.visibility = "show"
	if (is.ns4) obj.visibility = "show"
	//bc:else if (is.ie) obj.visibility = "visible"
	else if (is.ie||is.ns5) obj.visibility = "visible"
}
function hide(obj) {
	//bc:if (is.ns) obj.visibility = "hide"
	if (is.ns4) obj.visibility = "hide"
	//bc:else if (is.ie) obj.visibility = "hidden"
	else if (is.ie||is.ns5) obj.visibility = "hidden"
}

// movement functions
function getX(obj) {
	//bc:if (is.ns) return obj.css.left
	if (is.ns4) return obj.css.left
	//bc:else return obj.css.pixelLeft
	else if (is.ie) return obj.css.pixelLeft
	else if (is.ns5) return obj.css.offsetLeft
}
function getY(obj) {
	//bc:if (is.ns) return obj.css.top
	if (is.ns4) return obj.css.top
	//bc:else return obj.css.pixelTop
	else if (is.ie) return obj.css.pixelTop
	else if (is.ns5) return obj.css.offsetTop
}
function setX(obj,x) {
	//bc:if (is.ns) obj.css.left = x
	if (is.ns4) obj.css.left = x
	//bc:else obj.css.pixelLeft = x
	else obj.css.left = x
}
function setY(obj,y) {
	//bc:if (is.ns) obj.css.top = y
	if (is.ns4) obj.css.top = y
	//bc:else obj.css.pixelTop = y
	else obj.css.top = y
}
function moveTo(obj,x,y) {
	if (x!=null) setX(obj,x)
	if (y!=null)setY(obj,y)
}
function moveBy(obj,x,y) {
	setX(obj,getX(obj)+x)
	setY(obj,getY(obj)+y)
}

// layer write function
function layerWrite(elm,text) {  // use getElement()
	//bc:if (is.ns) {
	if (is.ns4) {
		elm.open()
		elm.write(text)
		elm.close()
	}
	else elm.innerHTML = text
}

// background color
function setbg(obj,color) {
	//bc:if (is.ns) obj.document.bgColor = color
	if (is.ns4) obj.document.bgColor = color
	else obj.backgroundColor = color
}
