/*
 * $Id: DOMCommon.js,v 1.7 2003/09/14 21:22:26 bc Exp $
 *
 */

// Define standard constants for DOM

/* ***** BEGIN LICENSE BLOCK *****
 * The contents of this file are subject to the Mozilla Public License Version 
 * 1.1 (the "License"); you may not use this file except in compliance with 
 * the License. You may obtain a copy of the License at 
 * http://www.mozilla.org/MPL/
 * 
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 * 
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Bob Clary code.
 *
 * The Initial Developer of the Original Code is
 * Bob Clary.
 * Portions created by the Initial Developer are Copyright (C) 2000
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Bob Clary <http://bclary.com/>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 * 
 ***** END LICENSE BLOCK ***** */

////////////////////////////////////////////
// NODE TYPES
var ELEMENT_NODE                 = 1;
var ATTRIBUTE_NODE               = 2;
var TEXT_NODE                    = 3;
var CDATA_SECTION_NODE           = 4;
var ENTITY_REFERENCE_NODE        = 5;
var ENTITY_NODE                  = 6;
var PROCESSING_INSTRUCTION_NODE  = 7;
var COMMENT_NODE                 = 8;
var DOCUMENT_NODE                = 9;
var DOCUMENT_TYPE_NODE           = 10;
var DOCUMENT_FRAGMENT_NODE       = 11;
var NOTATION_NODE                = 12;
////////////////////////////////////////////
// DOM EXCEPTIONS
var INDEX_SIZE_ERR               = 1;
var DOMSTRING_SIZE_ERR           = 2;
var HIERARCHY_REQUEST_ERR        = 3;
var WRONG_DOCUMENT_ERR           = 4;
var INVALID_CHARACTER_ERR        = 5;
var NO_DATA_ALLOWED_ERR          = 6;
var NO_MODIFICATION_ALLOWED_ERR  = 7;
var NOT_FOUND_ERR                = 8;
var NOT_SUPPORTED_ERR            = 9;
var INUSE_ATTRIBUTE_ERR          = 10;
// introduced in DOM Level 2
var INVALID_STATE_ERR            = 11;
var SYNTAX_ERR                   = 12;
var INVALID_MODIFICATION_ERR     = 13;
var NAMESPACE_ERR                = 14;
var INVALID_ACCESS_ERR           = 15;
////////////////////////////////////////////
// CSS EXCEPTIONS
var CSS_SYNTAX_ERR               = 0;
var CSS_INVALID_MODIFICATION_ERR = 1;
////////////////////////////////////////////
// CSS RuleTypes
var UNKNOWN_RULE                 = 0;
var STYLE_RULE                   = 1;
var CHARSET_RULE                 = 2;
var IMPORT_RULE                  = 3;
var MEDIA_RULE                   = 4;
var FONT_FACE_RULE               = 5;
var PAGE_RULE                    = 6;


// xbDOM_DOMException

_classes.registerClass('xbDOM_DOMException');

function xbDOM_DOMException(code, message)
{
  _classes.defineClass('xbDOM_DOMException', _prototype_func);
  
  this.init(code, message);

  function _prototype_func()
  {
    xbDOM_DOMException.prototype.code = 0;
    
    xbDOM_DOMException.prototype.init = init;
    function init(code, message) 
    {
      this.parentMethod('init');    
      if (!code) code = 0;
      if (!message) message = '';
      this.code = code;
      this.message = message;
    }

    xbDOM_DOMException.prototype.getCode = getCode;
    function getCode()
    { return this._code; }

    xbDOM_DOMException.prototype._setCode = _setCode;
    function _setCode(code)
    { this._code = code; }
    
    xbDOM_DOMException.prototype.getMessage = getMessage;
    function getMessage()
    { return this._message; }

    xbDOM_DOMException.prototype._setMessage = _setMessage;
    function _setMessage(message)
    { this._message = message; }
    
  }
}

// convenience function
function xbDOM_not_impl() { throw (new xbDOM_DOMException(NOT_SUPPORTED_ERR, 'NOT_SUPPORTED_ERR')); }

function xbDOM_ProcessNamespaceData(namespaceURI, qualifiedName)
{
  var data = new Object;
  var names    = qualifiedName.split(':');

  data.prefix    = null;
  data.localName  = null;

  if (names.length == 1)
  {
    data.prefix = null;
    data.localName = qualifiedName;
  }
  else
  {
    data.prefix      = typeof(names[0]) == 'string' ? names[0] : null;
    data.localName    = names[1];
  }
      
  if (data.prefix != null && namespaceURI == null)
    throw (new xbDOM_DOMException(NAMESPACE_ERR));
      
  if (data.prefix == 'xml' && namespaceURI != 'http://www.w3.org/XML/1998/namespace')
    throw (new xbDOM_DOMException(NAMESPACE_ERR));

  if (data.prefix == 'xmlns' && namespaceURI != 'http://www.w3.org/2000/xmlns/')
    throw (new xbDOM_DOMException(NAMESPACE_ERR));
        
  return data;
}    

function __checkHierarchy(childNode)
{
  var childType = childNode.getNodeType();
  var thisType  = this.getNodeType();
      
  switch(thisType)
  {
  case DOCUMENT_NODE:
    switch(childType)
    {
    case ELEMENT_NODE:
    case PROCESSING_INSTRUCTION_NODE:
    case COMMENT_NODE:
    case DOCUMENT_TYPE_NODE:
      break;
    default:
      throw(new xbDOM_DOMException(HIERARCHY_REQUEST_ERR));
      break;
    }
    break;
  case DOCUMENT_FRAGMENT_NODE:
    switch(childType)
    {
    case ELEMENT_NODE:
    case PROCESSING_INSTRUCTION_NODE:
    case COMMENT_NODE:
    case TEXT_NODE:
    case CDATA_SECTION_NODE:
    case ENTITY_REFERENCE_NODE:
      break;
    default:
      throw(new xbDOM_DOMException(HIERARCHY_REQUEST_ERR));
      break;
    }
    break;
  case DOCUMENT_TYPE_NODE:
    throw(new xbDOM_DOMException(HIERARCHY_REQUEST_ERR));
    break;
  case ENTITY_REFERENCE_NODE:
    switch(childType)
    {
    case ELEMENT_NODE:
    case PROCESSING_INSTRUCTION_NODE:
    case COMMENT_NODE:
    case TEXT_NODE:
    case CDATA_SECTION_NODE:
    case ENTITY_REFERENCE_NODE:
      break;
    default:
      throw(new xbDOM_DOMException(HIERARCHY_REQUEST_ERR));
      break;
    }
    break;
  case ELEMENT_NODE:
    switch(childType)
    {
    case ELEMENT_NODE:
    case PROCESSING_INSTRUCTION_NODE:
    case COMMENT_NODE:
    case TEXT_NODE:
    case CDATA_SECTION_NODE:
    case ENTITY_REFERENCE_NODE:
      break;
    default:
      throw(new xbDOM_DOMException(HIERARCHY_REQUEST_ERR));
      break;
    }
    break;
  case ATTRIBUTE_NODE:
    switch(childType)
    {
    case TEXT_NODE:
    case ENTITY_REFERENCE_NODE:
      break;
    default:
      throw(new xbDOM_DOMException(HIERARCHY_REQUEST_ERR));
      break;
    }
    break;
  case PROCESSING_INSTRUCTION_NODE:
    throw(new xbDOM_DOMException(HIERARCHY_REQUEST_ERR));
    break;
  case COMMENT_NODE:
    throw(new xbDOM_DOMException(HIERARCHY_REQUEST_ERR));
    break;
  case TEXT_NODE:
    throw(new xbDOM_DOMException(HIERARCHY_REQUEST_ERR));
    break;
  case CDATA_SECTION_NODE:
    throw(new xbDOM_DOMException(HIERARCHY_REQUEST_ERR));
    break;
  case ENTITY_NODE:
    switch(childType)
    {
    case ELEMENT_NODE:
    case PROCESSING_INSTRUCTION_NODE:
    case COMMENT_NODE:
    case TEXT_NODE:
    case CDATA_SECTION_NODE:
    case ENTITY_REFERENCE_NODE:
      break;
    default:
      throw(new xbDOM_DOMException(HIERARCHY_REQUEST_ERR));
      break;
    }
    break;
  case NOTATION_NODE:
    throw(new xbDOM_DOMException(HIERARCHY_REQUEST_ERR));
    break;
  default:
    throw(new xbDOM_DOMException(HIERARCHY_REQUEST_ERR));
    break;
  }
}
