/*
 * $Id: FileReader.js,v 1.8 2003/09/14 21:22:26 bc Exp $
 *
 */

/* ***** BEGIN LICENSE BLOCK *****
 * The contents of this file are subject to the Mozilla Public License Version 
 * 1.1 (the "License"); you may not use this file except in compliance with 
 * the License. You may obtain a copy of the License at 
 * http://www.mozilla.org/MPL/
 * 
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 * 
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Bob Clary code.
 *
 * The Initial Developer of the Original Code is
 * Bob Clary.
 * Portions created by the Initial Developer are Copyright (C) 2000
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Bob Clary <http://bclary.com/>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 * 
 ***** END LICENSE BLOCK ***** */

registerFile('FileReader.js');

/*
  FileReader(url, onloadName);
  
  url      url of file to be read
  onloadName  name of onload handler function onloadName(sHtml)
  
*/

var _FileReader_Window = null;
var _FileReader_Html = '';

function FileReader(href, onloadName)
{
  var features = 'height=10,width=10,toolbar=no,location=no,directories=no,status=no,menubar=no,scrollbars=no,resizable=no';
  
  // open a small window to load the manpage into...
  _FileReader_Window = window.open(href, '_FileReader_Window', features);
  
  // check if page loaded.
  setTimeout('_FileReaderCheck("' + onloadName + '")', 200);
  
  // get the focus back
  _FileReader_Window.blur();
  self.focus();
}

function _FileReaderCheck(onloadName)
{
  var e;
  
  try 
  { 
    if (_FileReader_Window.document && _FileReader_Window.document.documentElement)
      if (_FileReader_Window.document.documentElement.nodeName == 'HTML')
        _FileReader_Html = _FileReader_Window.document.body.innerHTML;
      else
        _FileReader_Html = toXML(_FileReader_Window.document.documentElement);
      
    // handle slow connections
    if (!_FileReader_Html)
    {
      setTimeout('_FileReaderCheck("' + onloadName + '")', 200);
      return;
    }
    
  }
  catch (e) 
  { 
    setTimeout('_FileReaderCheck("' + onloadName + '")', 200);
    return;
  }

  _FileReader_Window.close();
  _FileReader_Window = null;
  
  eval(onloadName + '(_FileReader_Html)');
  
  //_FileReader_Html = '';
}

function toXML(node)
{
  if (node.toXML)
    return node.toXML();
    
  var s;
  var i;
  
  switch(node.nodeType)
  {
  case 3: // TEXT_NODE
    return node.data;
  case 4: // CDATA_SECTION_NODE
    return '<![CDATA[' + node.data + ']]>';
  case 8: // COMMENT_NODE
    return '<!--' + node.data + '-->';
  case 1: // ELEMENT_NODE
    s = '<' + node.nodeName;
        
    var attr;
    for (i = 0; i < node.attributes.length; i++)
    {
      attr = node.attributes.item(i);
      if (attr.nodeValue)
        s += ' ' + attr.nodeName + '=' + '"' + attr.nodeValue + '"';
    }
    s += '>';

    for (i = 0; i < node.childNodes.length; i++)
      s += toXML(node.childNodes.item(i));
            
    s += '</' + node.nodeName + '>';
            
    return s;
  }
  
  return '';
}

