/*
 * $Id: IE_emulation.js,v 1.6 2003/09/14 21:15:14 bc Exp $
 *
 */

/* ***** BEGIN LICENSE BLOCK *****
 * The contents of this file are subject to the Mozilla Public License Version 
 * 1.1 (the "License"); you may not use this file except in compliance with 
 * the License. You may obtain a copy of the License at 
 * http://www.mozilla.org/MPL/
 * 
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 * 
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Netscape code.
 *
 * The Initial Developer of the Original Code is
 * Netscape Corporation.
 * Portions created by the Initial Developer are Copyright (C) 2001
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Bob Clary <bclary@netscape.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 * 
 ***** END LICENSE BLOCK ***** */

/*
object.__defineSetter__(sPropertyName, fSetterFunction)
object.__defineGetter__(sPropertyName, fGetterFunction)
*/

// capture all events and initialize the IE only window.event object
// for all attribute based event handlers
function ieInitEvent(evt)
{
  window.event = evt;
}

var _w3cEventNames = ['load', 'unload', 'abort', 'error', 'select', 'change', 'submit', 'reset', 'focus', 'blur', 'click', 'mousedown', 'mouseup', 'mousemove', 'mouseover', 'mouseout', 'resize', 'focusin', 'focusout', 'gainselection', 'loselection', 'activate', 'keypress', 'keydown', 'keyup' ];

for (var i = 0; i < _w3cEventNames.length; i++) 
{	
  document.addEventListener(_w3cEventNames[i], ieInitEvent, true);
}

function ieInitElementRefs(evt)
{
  var i;
  var elm;

  for (i = 0; i < document.all.length; i++)
  {
     elm = document.all[i];

     if (elm.id)
     	eval(elm.id + ' = document.all[' + elm.id  + ']');
  }
  return true;
}

document.addEventListener('load', ieInitElementRefs, true);

/* convert string to integer */

function stringToInt(s, base)
{
   if (typeof(base) == 'undefined')
   	base = 10;

   var val = parseInt(s, base);
   if (isNaN(val))
      val = 0;

   return val;
}

/* Generic Event Model */

if ( Event && Event.prototype && Event.prototype.__defineGetter__ )
{
    Event.prototype.__defineGetter__( 'srcElement', 
    function()
    {
      var src = this.target;
      if( src.nodeName == '#text' ) 
        src = src.parentNode;
       return src;
    }
    );

    Event.prototype.__defineGetter__('returnValue',
    function()
    {
      return this.__returnValue;
    }
    );

    Event.prototype.__defineSetter__('returnValue',
    function(val)
    {
      if (typeof(val) != 'undefined' && !val)
        this.preventDefault();

      this.__returnValue = val;
      return val;
    }
    );

    Event.prototype.__defineGetter__('cancelBubble',
    function()
    {
      return this.__cancelBubble;
    }
    );

    Event.prototype.__defineSetter__('cancelBubble',
    function(val)
    {
      if (typeof(val) != 'undefined' && !val)
        this.stopProgation();

      this.__cancelBubble = val;
      return val;
    }
    );
}

/* Event model */
/* Mozilla doesn't support Event object ? */

if ( Event && Event.prototype && Event.prototype.__defineGetter__ )
{
  Event.prototype.__defineGetter__( 'fromElement', 
  function () 
  {
   var node;
   if (this.type == 'mouseover')
      node = this.relatedTarget;
   else if (this.type == 'mouseout')
      node = this.target;
   else
      node = null;

   while (node && node.nodeType != node.ELEMENT_NODE) 
     node = node.parentNode;

   this.__fromElement = node;
   return node;
  }
  );

  Event.prototype.__defineGetter__('toElement', 
  function () 
  {
    var node;
    if (this.type == 'mouseout')
      node = this.relatedTarget;
    else if (this.type == 'mouseover')
      node = this.target;
    else
      node = null;

    while (node && node.nodeType != node.ELEMENT_NODE) 
      node = node.parentNode;

    this.__toElement = node;

    return node;
  }
  );

  Event.prototype.__defineGetter__('offsetX', 
  function () 
  {
    return this.layerX;
  }
  );

  Event.prototype.__defineGetter__('offsetY', 
  function () 
  {
    return this.layerY;
  }
  );
}

/* TODO: KeyEvent Model */

function getStyleProperty(elm, propName)
{
  var val = null;
  
  if (getComputedStyle && document.getElementById)
     val = getComputedStyle(elm, null).getPropertyValue(propName);

  return val;
}

/* HTMLElement Model */

if ( HTMLElement && HTMLElement.prototype && HTMLElement.prototype.__defineGetter__ )
{
  HTMLElement.prototype.attachEvent = 
  function (ieEventType, ieEventHandler) 
  {
     var eventName = ieEventType.replace(/on/, '');
     ieEventHandler._w3cEventHandler = function (evt) 
     {
       window.event = evt;
       window.event.returnValue = ieEventHandler();
       return window.event.returnValue;
     };
     this.addEventListener(eventName, ieEventHandler._w3cEventHandler, false);
  };

  HTMLElement.prototype.detachEvent = 
  function (ieEventType, ieEventHandler) 
  {
    var excp;
    var eventName = ieEventType.replace(/on/, '');
    try
    {
      this.removeEventListener(eventName, ieEventHandler._w3cEventHandler, false);
    }
    catch(excp)
    {
    }
  };

  HTMLElement.prototype.__defineSetter__('innerText', 
  function (sText) 
  {
    this.innerHTML = sText.replace(/\&/g, '&amp;').replace(/</g, '&lt;').replace(/>/g, '&gt;');
  }
  );

  HTMLElement.prototype.__defineGetter__('innerText', 
  function () 
  {
    var r = this.ownerDocument.createRange();
    r.selectNodeContents(this);
    return r.toString();
  }
  );

  var _emptyTags = 
  {
    'IMG':   true,
    'BR':    true,
    'INPUT': true,
    'META':  true,
    'LINK':  true,
    'PARAM': true,
    'HR':    true
  };

  HTMLElement.prototype.__defineGetter__('outerHTML', 
  function () 
  {
    var attrs = this.attributes;
    var str = '<' + this.tagName;
    for (var i = 0; i < attrs.length; i++)
       str += ' ' + attrs[i].name + '="' + attrs[i].value + '"';

    if (_emptyTags[this.tagName])
       return str + '>';

    return str + '>' + this.innerHTML + '</' + this.tagName + '>';
  }
  );

  // TODO: ? outerText 

  HTMLElement.prototype.insertAdjacentHTML = 
  function (sWhere, sHTML) 
  {
     var df;   // : DocumentFragment
     var r = this.ownerDocument.createRange();
     
     switch (String(sWhere).toLowerCase()) 
     {  // convert to string and unify case
        case 'beforebegin':
           r.setStartBefore(this);
           df = r.createContextualFragment(sHTML);
           this.parentNode.insertBefore(df, this);
           break;
           
        case 'afterbegin':
           r.selectNodeContents(this);
           r.collapse(true);
           df = r.createContextualFragment(sHTML);
           this.insertBefore(df, this.firstChild);
           break;
           
        case 'beforeend':
           r.selectNodeContents(this);
           r.collapse(false);
           df = r.createContextualFragment(sHTML);
           this.appendChild(df);
           break;
           
        case 'afterend':
           r.setStartAfter(this);
           df = r.createContextualFragment(sHTML);
           this.parentNode.insertBefore(df, this.nextSibling);
           break;
     }   
  };

  HTMLElement.prototype.insertAdjacentText = 
  function (sWhere, sText) 
  {
    sText = sText.replace(/\&/g, '&amp;').replace(/</g, '&lt;').replace(/>/g, '&gt;');
    this.insertAdjacentHTML(sWhere, sText);
  };

  HTMLElement.prototype.__defineGetter__('parentElement', 
  function () 
  {
    var node = this.parentNode;

    while (node != this.ownerDocument && node.nodeType != node.ELEMENT_NODE)
      node = node.parentNode;

    if (node == this.ownerDocument) 
      node = null;
    return node;
  }
  );

  HTMLElement.prototype.__defineGetter__('children', 
  function ()
  {
    return this.getElementsByTagName('*');
  }
  );

  HTMLElement.prototype.contains = 
  function (elm) 
  {
    while (elm)
    {
      if (elm == this) 
        return true;
      
      elm = elm.parentElement;
    } 

    return false;
  };

  function allGetter() 
  {
    var a = this.getElementsByTagName("*");
    var node = this;
    a.tags = function (sTagName) 
    {
      return node.getElementsByTagName(sTagName);
    };
    return a;
  };

  HTMLDocument.prototype.__defineGetter__('all', allGetter);
  HTMLElement.prototype.__defineGetter__('all', allGetter);

  /* css and positional properties */

  HTMLElement.prototype.__defineGetter__('clientTop',
  function ()
  {
    return this.offsetTop + getStyleProperty(this, 'border-top');
  }
  );

  HTMLElement.prototype.__defineGetter__('clientRight',
  function ()
  {
    return this.offsetRight + getStyleProperty(this, 'border-right');
  }
  );

  HTMLElement.prototype.__defineGetter__('clientBottom',
  function ()
  {
    return this.offsetBottom + getStyleProperty(this, 'border-bottom');
  }
  );

  HTMLElement.prototype.__defineGetter__('clientLeft',
  function ()
  {
    return this.offsetLeft + getStyleProperty(this, 'border-left');
  }
  );

}

if ( CSSStyleDeclaration && CSSStyleDeclaration.prototype && CSSStyleDeclaration.prototype.__defineGetter__ )
{
  CSSStyleDeclaration.prototype.__defineGetter__('pixelTop',
  function ()
  {
    return stringToInt(this.top, 10);
  }
  );

  CSSStyleDeclaration.prototype.__defineSetter__('pixelTop',
  function (val)
  {
    this.top = val + 'px';
  }
  );

  CSSStyleDeclaration.prototype.__defineGetter__('pixelRight',
  function ()
  {
    return stringToInt(this.right, 10);
  }
  );

  CSSStyleDeclaration.prototype.__defineSetter__('pixelRight',
  function (val)
  {
    this.right = val + 'px';
  }
  );

  CSSStyleDeclaration.prototype.__defineGetter__('pixelBottom',
  function ()
  {
    return stringToInt(this.bottom, 10);
  }
  );

  CSSStyleDeclaration.prototype.__defineSetter__('pixelBottom',
  function (val)
  {
    this.bottom = val + 'px';
  }
  );

  CSSStyleDeclaration.prototype.__defineGetter__('pixelLeft',
  function ()
  {
    return stringToInt(this.left, 10);
  }
  );

  CSSStyleDeclaration.prototype.__defineSetter__('pixelLeft',
  function (val)
  {
    this.left = val + 'px';
  }
  );

  function getLengthUnits(s)
  {
     var units = '';

     if (s.length > 2)
       units = s.substr(s.length - 2);         

     return units;
   }

  CSSStyleDeclaration.prototype.__defineGetter__('posTop',
  function ()
  {
    return stringToInt(this.top, 10);
  }
  );

  CSSStyleDeclaration.prototype.__defineSetter__('posTop',
  function (val)
  {
    this.top = this.posTop + getLengthUnits(this.top);
  }
  );

  CSSStyleDeclaration.prototype.__defineGetter__('posRight',
  function ()
  {
    return stringToInt(this.right, 10);
  }
  );

  CSSStyleDeclaration.prototype.__defineSetter__('posRight',
  function (val)
  {
    this.right = this.posRight + getLengthUnits(this.right);
  }
  );

  CSSStyleDeclaration.prototype.__defineGetter__('posBottom',
  function ()
  {
    return stringToInt(this.bottom, 10);
  }
  );

  CSSStyleDeclaration.prototype.__defineSetter__('posBottom',
  function (val)
  {
    this.bottom = this.posBottom + getLengthUnits(this.bottom);
  }
  );

  CSSStyleDeclaration.prototype.__defineGetter__('posLeft',
  function ()
  {
    return stringToInt(this.left, 10);
  }
  );

  CSSStyleDeclaration.prototype.__defineSetter__('posLeft',
  function (val)
  {
    this.left = this.posLeft + getLengthUnits(this.left);
  }
  );

}

