/*
 * $Id: popup.js,v 1.7 2003/09/14 21:22:26 bc Exp $
 *
 */

// implement a pop up message window class

/* ***** BEGIN LICENSE BLOCK *****
 * The contents of this file are subject to the Mozilla Public License Version 
 * 1.1 (the "License"); you may not use this file except in compliance with 
 * the License. You may obtain a copy of the License at 
 * http://www.mozilla.org/MPL/
 * 
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 * 
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Bob Clary code.
 *
 * The Initial Developer of the Original Code is
 * Bob Clary.
 * Portions created by the Initial Developer are Copyright (C) 2000
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Bob Clary <http://bclary.com/>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 * 
 ***** END LICENSE BLOCK ***** */

_classes.registerClass('MessageWindow');

function MessageWindow(id, message)
{
  _classes.defineClass('MessageWindow', _prototype_func);
  
  this.init(id, message);
  
  function _prototype_func()
  {
    MessageWindow.prototype.init = init;
    function init(id, message)
    {
      var features = 'height=130,width=130,toolbar=no,location=no,directories=no,status=no,menubar=no,scrollbars=no,resizable=yes';

      this.id    = id;
      this.wnd  = window.open('', 'popup_' + id, features);
      
      if (!this.wnd)
        return;
      
      // mozilla throws an exception componet has no such interface
      //this.wnd.focus();

      // note mozilla won't display the message when writing to the 
      // document but will do so 'belatedly' when using innerHTML
      // closing the message window's document helps somewhat.
      // it appears the text isn't rendered until the opening window
      // finishes loading.
      var s = '';
      s += '<html>';
      s += '<body style="background-color: white; padding: 10px; margin: 0px; padding: 0px;">';
      s += '<div style="padding: 10px;">';
      s += message;
      s += '</div>';
      s += '</body></html>';
      this.wnd.document.write(s);
      //this.wnd.document.body.innerHTML = s;
      this.wnd.document.close();
    }
    
    
    MessageWindow.prototype.close = close;
    function close()
    {
      if (!this.wnd || this.wnd.closed)
        return;
        
      // mozilla throws an exception componet has no such interface
      //this.wnd.blur();
      // mozilla throws an exception componet has no such interface
      this.wnd.close();
      //window.focus();
    }
  }
}

_classes.registerClass('PopupWindow');

function PopupWindow(id, message)
{
  _classes.defineClass('PopupWindow', _prototype_func);
  
  this.init(id, message);
  
  function _prototype_func()
  {
    PopupWindow.prototype.init = init;
    function init(id, message)
    {
      this.id = id;
      
      var div = document.getElementById('popup_' + id);
    
      if (!div)
      {
        if (document.body)
        {
          div                       = document.createElement('div');
          div.id                    = 'popup_' + id;
          div.style.position        = 'absolute';
          div.style.visibility      = 'visible';
          div.style.zIndex          = -1;
          div.style.backgroundColor = '#d6d6ce';
          div.style.padding         = '10px';
          div.style.borderTop       = '#808080 4px solid';
          div.style.borderRight     = '#f0f0f0 4px solid';
          div.style.borderBottom    = '#f0f0f0 4px solid';
          div.style.borderLeft      = '#808080 4px solid';

          document.body.appendChild(div);
        }

        var bodyHeight = 0; 
        var bodyWidth  = 0;
          
        if (typeof(document.body.offsetWidth) == 'number')
        {
          bodyHeight = document.body.offsetHeight;
          bodyWidth  = document.body.offsetWidth;
        }
        else if (typeof(document.width) == 'number')
        {
          bodyHeight = document.width;
          bodyWidth  = document.height;
        }
      
        div.innerHTML = message;
    
        if (div.offsetWidth > bodyWidth)
          div.style.width = bodyWidth;
          
        if (div.offsetHeight > bodyHeight)
          div.style.height = bodyHeight;
          
        div.style.left  = (bodyWidth  - div.offsetWidth)/2;
        div.style.top  = (bodyHeight - div.offsetHeight)/2;

      }
      
      div.style.zIndex    = 1;
      div.style.visibility = 'visible';
    }
    
    PopupWindow.prototype.close = close;
    function close()
    {
      var div = document.getElementById('popup_' + this.id);
      if (!div)
        return;
          
      div.style.zIndex    = -1;
      div.style.visibility  = 'hidden';
    }
  }
}
