/*
 * $Id: tc-utils.js,v 1.7 2003/09/14 21:22:26 bc Exp $
 *
 */

/* ***** BEGIN LICENSE BLOCK *****
 * The contents of this file are subject to the Mozilla Public License Version 
 * 1.1 (the "License"); you may not use this file except in compliance with 
 * the License. You may obtain a copy of the License at 
 * http://www.mozilla.org/MPL/
 * 
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 * 
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Bob Clary code.
 *
 * The Initial Developer of the Original Code is
 * Bob Clary.
 * Portions created by the Initial Developer are Copyright (C) 2000
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Bob Clary <http://bclary.com/>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 * 
 ***** END LICENSE BLOCK ***** */

function bugzilla(id,label)
{
  return '<a target="bugs" href="http://bugzilla.mozilla.org/show_bug.cgi?id=' + id + '">Bugzilla ' + id + '</a>';
}

function isNonNullObject(obj)
{
  return (typeof(obj) ==  "object") && (obj != null);
}
// return a standard string representing the structure
// of a node so that it can be compared to a string.
function checkNodeStructure(node, parentNode, previousSibling, nextSibling, children)
{
  if (node.parentNode != parentNode)
    return false;
    
  if (node.previousSibling != previousSibling)
    return false;
    
  if (node.nextSibling != nextSibling)
    return false;
    
  if (node.childNodes.length != children.length)
    return false;
    
  var i;
  
  for (i = 0; i < node.childNodes.length; i++)
    if (node.childNodes.item(i) != children[i])
      return false;
      
  return true;
}
  
function compareNodesMessage(property, nodeName, leftval, rightval)
{
  return 'not equal, Left Node ' + nodeName + '\'s ' + property + '[' + leftval + '] differs from Right Node\'s [' + rightval + ']';
}

function compareNodes(left, right)
{
  var i;
  var msg;
  
  if (left.nodeName != right.nodeName)
    return compareNodesMessage('nodeName', left.nodeName, left.nodeName, right.nodeName);

  if (left.nodeType != right.nodeType)
    return compareNodesMessage('nodeType', left.nodeName, left.nodeType, right.nodeType);

  if (left.nodeValue != right.nodeValue)
    return compareNodesMessage('nodeValue', left.nodeName, left.nodeValue, right.nodeValue);

  if (left.localName != right.localName)
    return compareNodesMessage('localName', left.nodeName, left.localName, right.localName);

  if (left.namespaceURI != right.namespaceURI)
    return compareNodesMessage('namespaceURI', left.nodeName, left.namespaceURI, right.namespaceURI);

  if (left.ownerDocument != right.ownerDocument)
    return compareNodesMessage('ownerDocument', left.nodeName, left.ownerDocument, right.ownerDocument);
    
  if (left.prefix != right.prefix)
    return compareNodesMessage('prefix', left.nodeName, left.prefix, right.prefix);
    
  if (left.attributes && !right.attributes || !left.attributes && right.attributes)
    return compareNodesMessage('attributes', left.nodeName, left.attributes, right.attributes);

  switch (left.nodeType)
  {
  case ELEMENT_NODE:
    if (left.tagName != right.tagName)
      return compareNodesMessage('tagName', left.nodeName, left.tagName, right.tagName);    
    break;
  case ATTRIBUTE_NODE:
    if (left.name != right.name)
      return compareNodesMessage('name', left.nodeName, left.name, right.name);    
    if (left.value != right.value)
      return compareNodesMessage('value', left.nodeName, left.value, right.value);    
    break;
  case TEXT_NODE:
  case CDATA_SECTION_NODE:
  case COMMENT_NODE:
    if (left.data != right.data)
      return compareNodesMessage('data', left.nodeName, left.data, right.data);    
    break;
  case ENTITY_REFERENCE_NODE:
    break;
  case ENTITY_NODE:
    break;
  case PROCESSING_INSTRUCTION_NODE:
    if (left.target != right.target)
      return compareNodesMessage('target', left.nodeName, left.target, right.target);    
    if (left.data != right.data)
      return compareNodesMessage('data', left.nodeName, left.data, right.data);    
    break;
  case DOCUMENT_NODE:
    break;
  case DOCUMENT_TYPE_NODE:
    break;
  case DOCUMENT_FRAGMENT_NODE:
    break;
  case NOTATION_NODE:
    break;
  }
  
  if (left.attributes)
  {
    if (left.attributes.length != right.attributes.length)
      return compareNodesMessage('attributes.length', left.nodeName, left.attributes.length, right.attributes.length);

    for (i = 0; i < left.attributes.length; i++)
    {
      msg = compareNodes(left.attributes.item(i), right.attributes.item(i));
      if (msg != 'equal')
        return msg;
    }    
  }    
  
  if (left.childNodes.length != right.childNodes.length)
    return compareNodesMessage('childNodes.length', left.nodeName, left.childNodes.length, right.childNodes.length);

  for (i = 0; i < left.childNodes.length; i++)
  {
    msg = compareNodes(left.childNodes.item(i), right.childNodes.item(i));
    if (msg != 'equal')
      return msg;
  }    
  
  return 'equal';
}

  
function isModifiable(objName)
{
  var e;  
  var saveObj;  
  var result  = true;
  try
  {
    // save object
    saveObj = eval(objName);    
    // try to write to it    
    eval(objName + ' = 0;');    
        
    if (eval(objName) == saveObj)
      result = false;
    else      
      try      
      {
        // try to reset
        eval(objName + ' = saveObj;');
      }      
      catch(e)      
      {
        ; // if reset failed. ignore it?      
      }
  }
  catch(e)
  {    
    result = false; // ok, it threw an exception. should be ok  
  }  
  return result;
  }


function destroyNode(node)
{
  var child;
  var nextChild;
  
  child = node.firstChild;
  while (child)
  {
    destroyNode(child);
    child = child.nextSibling;
  }
  
  child = node.firstChild;
  while (child)
  {
    nextChild = child.nextSibling;
    node.removeChild(child);
    child = nextChild;
  }
}
