/*
 * $Id: windowOpenOnLoad.js,v 1.7 2003/09/14 21:22:26 bc Exp $
 *
 */

// emulate window.open with an onload handler
//

/* ***** BEGIN LICENSE BLOCK *****
 * The contents of this file are subject to the Mozilla Public License Version 
 * 1.1 (the "License"); you may not use this file except in compliance with 
 * the License. You may obtain a copy of the License at 
 * http://www.mozilla.org/MPL/
 * 
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 * 
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Initial Developer of the Original Code is
 * Bob Clary.
 * Portions created by the Initial Developer are Copyright (C) 2000
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Bob Clary <http://bclary.com/>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 * 
 ***** END LICENSE BLOCK ***** */

/*
windowRef = windowOpenOnLoad(url, windowName, windowFeatures, windowOnload);

windowRef      reference to opened window 

url          url of file to be read
windowName      name of window to be opened
windowFeatures    feature string for window
windowOnload    reference to onload handler function
*/

var _AsyncInterval    = 750;
var _AsyncWindowHash  = new Object();
var _AsyncWindowIndex  = 0;

function AsyncWindow(windowRef, windowOnload)
{
  this.window  = windowRef;
  this.onload  = windowOnload;
  this.id    = 'i' + _AsyncWindowIndex++;
  this.length = 0;
  this.lastlength = 0;
  
  _AsyncWindowHash[this.id] = this;
}


function windowOpenOnload(url, windowName, windowFeatures, windowOnload)
{
  var windowRef;
  
  if (!windowName)
    windowName = undefined;
    
  if (!windowFeatures)
    windowFeatures = undefined;
     
  windowRef = window.open(url, windowName, windowFeatures);
  
  var asyncWindow = new AsyncWindow(windowRef, windowOnload);

  setTimeout('_windowOpenOnLoadCheck("' + asyncWindow.id + '")', _AsyncInterval);
  
  return windowRef;
}

function _windowOpenOnLoadCheck(asyncWindowId)
{
  var e;
  var asyncWindow = _AsyncWindowHash[asyncWindowId];
  var windowRef = asyncWindow.window;
  
  
  try 
  { 
    if (!windowRef.document || !windowRef.document.body || !windowRef.document.body.innerHTML)
    {
      setTimeout('_windowOpenOnLoadCheck("' + asyncWindowId + '")', _AsyncInterval);
      return;
    }
    
  }
  catch (e) 
  { 
    setTimeout('_windowOpenOnLoadCheck("' + asyncWindowId + '")', _AsyncInterval);
    return;
  }
  
  asyncWindow.lastlength = asyncWindow.length;
  asyncWindow.length = document.body.innerHTML.length;
  
  if (asyncWindow.lastlength != asyncWindow.length)
  {
    setTimeout('_windowOpenOnLoadCheck("' + asyncWindowId + '")', _AsyncInterval);
    return;
  }
  
  xbDEBUG.dump(windowRef.document.body.innerHTML.escapeHTML());
  
  windowRef.asyncWindowOnloadHandler = asyncWindow.onload;
  windowRef.asyncWindowOnloadHandler();
  windowRef.asyncWindowOnloadHandler = null;
  delete _AsyncWindowHash[asyncWindowId];
  
}
