/*
 * $Id: xbAnimatedElement.js,v 1.3 2003/09/14 21:22:26 bc Exp $
 *
 */

/* ***** BEGIN LICENSE BLOCK *****
 * The contents of this file are subject to the Mozilla Public License Version 
 * 1.1 (the "License"); you may not use this file except in compliance with 
 * the License. You may obtain a copy of the License at 
 * http://www.mozilla.org/MPL/
 * 
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 * 
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Netscape Cross Browser Positionable Element code.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 2002
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Bob Clary <bclary@netscape.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 * 
 ***** END LICENSE BLOCK ***** */

/*
 * xbAnimatedElement - 
 * use DHMTL to position an element along a curve
 */

function xbAnimatedElement(id, pathFunc)
{
  this.id              = id;
  this.name            = 'xbAnimatedElement_' + (++xbAnimatedElement._name);
  this.runId           = null;  
  this.refreshInterval = 100;
  this.div             = null;
  this.pathFunc        = pathFunc;
  this.tick            = 0;
  
  window[this.name] = this;
}  

xbAnimatedElement._name = -1;

xbAnimatedElement.prototype.start = function ()
{
  this.stop();
  
  // since start() should be called after the document has loaded, we can finally assign element
  if (!this.div)
  {
    if (document.getElementById)
    {
      this.div = document.getElementById(this.id);
      this.styleObj = this.div.style;	
    }
    else if (document.layers)
    {
      this.div = document.layers[this.id];
      this.styleObj = this.div;
    }
    else if (document.all)
    {
      this.div = document.all[this.id];
      this.styleObj = this.div.style;	
    }
  }	
  
  var newPos = this.pathFunc(this.tick++);

  this.styleObj.left = newPos.x;
  this.styleObj.top  = newPos.y;

  this.runId = setTimeout(this.name + '.start()', this.refreshInterval);    
};

xbAnimatedElement.prototype.stop = function ()
{
  if (this.runId)
    clearTimeout(this.runId);
    
  this.runId = null;
};

