/*
 * $Id: xbArray.js,v 1.7 2003/09/14 21:22:26 bc Exp $
 *
 */

/* ***** BEGIN LICENSE BLOCK *****
 * The contents of this file are subject to the Mozilla Public License Version 
 * 1.1 (the "License"); you may not use this file except in compliance with 
 * the License. You may obtain a copy of the License at 
 * http://www.mozilla.org/MPL/
 * 
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 * 
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Bob Clary code.
 *
 * The Initial Developer of the Original Code is
 * Bob Clary.
 * Portions created by the Initial Developer are Copyright (C) 2000
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Bob Clary <http://bclary.com/>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 * 
 ***** END LICENSE BLOCK ***** */

// xbArray 

_classes.registerClass('xbArray');

function xbArray()
{
  _classes.defineClass('xbArray', _prototype_func);
  
  this.init();

  function _prototype_func()
  {
    function init()
    {
      this.parentMethod('init');
      this.list = new Array();
      this.length = 0;
    }
    xbArray.prototype.init      = init;

    function destroy()
    {
      var i;
      
      for (i = 0; i < this.list.length; i++)
      {
        if (this.list[i].destroy)
          this.list[i].destroy();
        else
          this.list[i] = null;
      }
      this.list = null;
      this.parentMethod('destroy');
    }
    xbArray.prototype.destroy    = destroy;
    
    function item(index)
    {
      if (index >= this.length)
        return null;
      else if (index < 0)
        return null;
      else
        return this.list[index];
    }
    xbArray.prototype.item      = item;
    
    function concat(array2)
    {
      if (array2.list.length == 0)
        return this;
      
      var newList  = new xbArray();
      newList.list = this.list.concat(array2.list);
      newList.length = newList.list.length;
      
      return newList;
    }
    xbArray.prototype.concat    = concat;
    
    function join(str) { return this.list.join(str); }
    xbArray.prototype.join      = join;

    function pop()
    {
      if (this.length == 0)
        return null;
        
      var node = this.list[this.length - 1];
      
      if (this.length == 1)
        this.list = new Array();
      else
        this.list = this.list.slice(0, this.length - 1);
        
      --this.length;
      
      return node;
    }
    xbArray.prototype.pop      = pop;
    
    function push(node)
    {
      this.list[this.length] = node;
      ++this.length;
      
      return node;
    }
    xbArray.prototype.push      = push;
    
    function top()
    {
      if (this.length == 0)
        return null;
        
      return this.list[this.length-1];
    }
    xbArray.prototype.top = top;
    
    function reverse()
    {
      this.list = this.list.reverse();
      return this;
    }
    xbArray.prototype.reverse    = reverse;
    
    function shift()
    {
      if (this.length == 0)
        return null;
        
      var node = this.list[0];
      
      if (this.length == 1)
        this.list = new Array();
      else
        this.list = this.list.slice(1);
        
      --this.length;
      
      return node;
    }
    xbArray.prototype.shift    = shift;

    function unshift(node)
    {
      var tempArray = new Array();
      tempArray[0] = node;
      
      this.list = tempArray.concat(this.list);
      
      ++this.length;
      
      return this.length;
    }
    xbArray.prototype.unshift    = unshift;
        
    function slice(startIndex, stopIndex)
    {
      var newList = new xbArray();
      if (!stopIndex)
        stopIndex = this.length;
        
      newList.list = this.list.slice(startIndex, stopIndex);
      newList.length = newList.list.length;
      
      return newList;
    }
    xbArray.prototype.slice    = slice;
    
    function sort(cmp)
    {
      var newList = new xbArray();
      newList.list = this.list.sort(cmp);
      newList.length = this.length;
      
      return newList;
    }
    xbArray.prototype.sort      = sort;

    function getLength()  { return this.length; }
    xbArray.prototype.getLength  = getLength;
  }
}

// eof: xbArray.js
//</SCRIPT>
