/*
 * $Id: xbAsyncOnload.js,v 1.7 2003/09/14 21:22:26 bc Exp $
 *
 */

// Cross Browser Onload Event Handling

/* ***** BEGIN LICENSE BLOCK *****
 * The contents of this file are subject to the Mozilla Public License Version 
 * 1.1 (the "License"); you may not use this file except in compliance with 
 * the License. You may obtain a copy of the License at 
 * http://www.mozilla.org/MPL/
 * 
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 * 
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Bob Clary code.
 *
 * The Initial Developer of the Original Code is
 * Bob Clary.
 * Portions created by the Initial Developer are Copyright (C) 2000
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Bob Clary <http://bclary.com/>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 * 
 ***** END LICENSE BLOCK ***** */

/*
Use readyState and onreadystate event handling for IE5
and polling for Netscape 6 to check on the status of an
onload event.

2001-07-07: bclary cloned from attempt into more general async loading util
*/

// set the domain to be the current domain less host name 
setDomain();

// Class used to manage data for onload callback

function xbAsyncOnloadManager(objectRef, onloadHandler, objectInvariant)
{
  // object that is being watched for onload
  this.objectRef      = objectRef; 
  
  // function to be called when onload complete
  this.onload        = onloadHandler;  
  
  // function returning something that will stop changing when the 
  // objectRef is completely loaded
  this.objectInvariant  = objectInvariant;
  
  // used to test if object has changed since last poll
  this.invariant      = null;        
  this.lastinvariant    = null;
  
  // id used to find in xbAsyncOnloadManager.hash
  this.id  = 'i' + xbAsyncOnloadManager.index++;  
  xbAsyncOnloadManager.hash[this.id] = this;
}

// Static Class variables

xbAsyncOnloadManager.interval  = 750;
xbAsyncOnloadManager.hash    = new Object();
xbAsyncOnloadManager.index    = 0;

function xbAsyncOnloadHandler(objectRef, onloadHandler, objectInvariant)
{
  xbDEBUG.dump('xbAsyncOnloadHandler');
  
  var mgr = new xbAsyncOnloadManager(objectRef, onloadHandler, objectInvariant);

  if (document.all)
  {
    xbDEBUG.dump('xbAsyncOnloadHandler readyState=' + objectRef.readyState);
    
    if (objectRef.readyState == 'complete')
      xbAsyncOnloadFire(mgr.id);
    else
      objectRef.onreadystatechange = new Function("xbDEBUG.dump('xbAsyncOnloadHandler readyState=' + this.readyState); if (this.readyState == 'complete'){xbAsyncOnloadFire(" + mgr.id + ") } ");
  }
  else
    setTimeout('xbAsyncOnloadPoll("' + mgr.id + '")', 3*xbAsyncOnloadManager.interval); // set initial check to be 3 times later interval
}

function xbAsyncOnloadPoll(id)
{
  xbDEBUG.dump('xbAsyncOnloadPoll id=' + id);

  var e;
  if (navigator.product == 'Gecko' && !sameDomain(objectRef))
    try
    {
      netscape.security.PrivilegeManager.enablePrivilege("UniversalBrowserRead UniversalBrowserWrite");
    }
    catch(e)
    {
      throw e;
    }
  
  var mgr      = xbAsyncOnloadManager.hash[id];
  var objectRef  = mgr.objectRef;

  mgr.lastinvariant  = mgr.invariant
  mgr.invariant    = mgr.objectInvariant(objectRef);
    
  xbDEBUG.dump('xbAsyncOnloadPoll objectRef invariant ' + mgr.invariant);

  if (mgr.lastinvariant != mgr.invariant)
  {
    setTimeout('xbAsyncOnloadPoll("' + id + '")', xbAsyncOnloadManager.interval);
    return;
  }
  
  xbAsyncOnloadFire(id)
}

function xbAsyncOnloadFire(id)
{
  xbDEBUG.dump('xbAsyncOnloadFire');

  var e;
  var mgr      = xbAsyncOnloadManager.hash[id];
  var objectRef  = mgr.objectRef;
  
  if (navigator.product == 'Gecko' && !sameDomain(objectRef))
    try
    {
      netscape.security.PrivilegeManager.enablePrivilege("UniversalBrowserRead UniversalBrowserWrite");
    }
    catch(e)
    {
      throw e;
    }
  
  objectRef.xbOnload = mgr.onload;
  objectRef.xbOnload();
  objectRef.xbOnload = null;
  delete xbAsyncOnloadManager.hash[id];
}
