/*
 * $Id: xbCookies.js,v 1.7 2003/09/14 21:22:26 bc Exp $
 *
 */

/* ***** BEGIN LICENSE BLOCK *****
 * The contents of this file are subject to the Mozilla Public License Version 
 * 1.1 (the "License"); you may not use this file except in compliance with 
 * the License. You may obtain a copy of the License at 
 * http://www.mozilla.org/MPL/
 * 
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 * 
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Bob Clary code.
 *
 * The Initial Developer of the Original Code is
 * Bob Clary.
 * Portions created by the Initial Developer are Copyright (C) 2000
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Bob Clary <http://bclary.com/>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 * 
 ***** END LICENSE BLOCK ***** */

/*
2001-08-21: bclary, modified extensively to handle cookies accurately.
*/

_classes.registerClass('xbCookie');

function xbCookie(name, value)
{
  _classes.defineClass('xbCookie', _prototype_func);
  
  this.init(name, value);
  
  function _prototype_func()
  {
    xbCookie.prototype.init = init;
    function init(name, value)
    {
      this.parentMethod('init');
      
      this.name    = name;
      this.value    = value;
      this.secure    = false;
      this.path    = undefined;
      this.domain    = undefined;
      this.expires  = undefined;
    }
    
    xbCookie.prototype.save = save;
    function save()
    {
      var s = this.name + '=' + escape(this.value) + ';';

      if (this.path)
        s += 'path=' + this.path + ';';
      
      if (this.domain)
        s += 'domain=' + this.domain + ';';
          
      if (this.expires)
        s += 'expires=' + this.expires + ';';
          
      if (this.secure)
        s += 'secure;';
          
      //alert('save cookie ' + s);    

      document.cookie = s;
    }
    
    xbCookie.prototype.setExpires = setExpires;
    function setExpires(date)
    {
      var expires = date;
      
      if (typeof(date) == 'number')
        expires = new Date(date);
    
      this.expires = expires.toGMTString();
    }
    
    xbCookie.prototype.setPath = setPath;
    function setPath(path)
    {
      this.path = path;
    }
    
    xbCookie.prototype.setDomain = setDomain;
    function setDomain(domain)
    {
      this.domain = domain;
    }
    
    xbCookie.prototype.setSecure = setSecure;
    function setSecure()
    {
      this.secure = true;
    }
    
  }
}


_classes.registerClass('xbCookies');

function xbCookies()
{
  _classes.defineClass('xbCookies', _prototype_func);
  
  this.init();
  
  function _prototype_func()
  {
    xbCookies.prototype.init = init;
    function init()
    {
      this.parentMethod('init');
      
      var q = document.cookie;

      //alert('document.cookies = ' + q);
      this.cookies = new Object();

      if (q)
      {
        var pairs = q.split(';');

        for (var i = 0; i < pairs.length; ++i)
        {
          var offset  = pairs[i].indexOf('=');
          var name  = pairs[i].substr(0, offset);
          var value  = pairs[i].substr(offset+1);
          
          name = name.replace(/^ +/, '');
          //alert('loaded cookie "' + name + '" = ' + value);
          this.cookies[name] = new xbCookie(name, unescape(value));
        }
      }
    }
    
    xbCookies.prototype.get = get;
    function get(name)
    {
      return this.cookies[name];
    }
    
    xbCookies.prototype.add = add;
    function add(name,value)
    {
      if (this.cookies[name])
        this.cookies[name].value = value;
      else
        this.cookies[name] = new xbCookie(name,value);
        
      return this.cookies[name];
    }
    
    xbCookies.prototype.save = save;
    function save()
    {
      var p;
      
      for (p in this.cookies)
        this.cookies[p].save();
    }
    
    xbCookies.prototype.setExpires = setExpires;
    function setExpires(date)
    {
      var p;
      
      for (p in this.cookies)
        this.cookies[p].setExpires(date);
    }
    
    xbCookies.prototype.setPath = setPath;
    function setPath(path)
    {
      var p;
      
      for (p in this.cookies)
        this.cookies[p].setPath(path);
    }
    
    xbCookies.prototype.setDomain = setDomain;
    function setDomain(domain)
    {
      var p;
      
      for (p in this.cookies)
        this.cookies[p].setDomain(domain);
    }
    
    xbCookies.prototype.setSecure = setSecure;
    function setSecure()
    {
      var p;
      
      for (p in this.cookies)
        this.cookies[p].setSecure();
    }
    
  }
}

// eof: xbCookies.js
