/*
 * $Id: xbDOM2.js,v 1.7 2003/09/14 21:22:26 bc Exp $
 */

/* ***** BEGIN LICENSE BLOCK *****
 * The contents of this file are subject to the Mozilla Public License Version 
 * 1.1 (the "License"); you may not use this file except in compliance with 
 * the License. You may obtain a copy of the License at 
 * http://www.mozilla.org/MPL/
 * 
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 * 
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Bob Clary code.
 *
 * The Initial Developer of the Original Code is
 * Bob Clary.
 * Portions created by the Initial Developer are Copyright (C) 2000
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Bob Clary <http://bclary.com/>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 * 
 ***** END LICENSE BLOCK ***** */

function createMSXML2DOMDocument()
{
  var newDoc;
  var eError;

  try    
  {      
    newDoc = new ActiveXObject('MSXML2.DOMDocument.4.0');
  }
  catch(eError)
  {
    try
    {
      newDoc = new ActiveXObject('MSXML2.DOMDocument');
    }
    catch (eError)
    {
      newDoc = null;
    }
  }
  return newDoc;
}

function createDOMDocument(doc, nodeName, newDoctype)
{
  var newDoc = null;    
  var eError;

  if (doc.implementation && doc.implementation.createDocument)
    newDoc = doc.implementation.createDocument(null, nodeName, newDoctype);
  else if (document.all && document.getElementById)
  {
    newDoc = createMSXML2DOMDocument();
    
    if (newDoc)
      newDoc.appendChild(newDoc.createElement(nodeName));
  }      
  return newDoc;    
}

function createDOMDocumentNS(namespaceURI, nodeName, newDoctype)
{
  var newDoc = null;    
  var eError;

  if (doc.implementation && doc.implementation.createDocument)
    newDoc = doc.implementation.createDocument(namespaceURI, nodeName, newDoctype);
  else if (document.all && document.getElementById)
  {
    newDoc = createMSXML2DOMDocument();
    
    if (newDoc)
      newDoc.appendChild(newDoc.createElementNS(namespaceURI, nodeName));
  }      
  return newDoc;
}

if (typeof(Node) == 'undefined')
{
  Node = function () {};
  ////////////////////////////////////////////
  // NODE TYPES
  Node.prototype.ELEMENT_NODE                 = 1;
  Node.prototype.ATTRIBUTE_NODE               = 2;
  Node.prototype.TEXT_NODE                    = 3;
  Node.prototype.CDATA_SECTION_NODE           = 4;
  Node.prototype.ENTITY_REFERENCE_NODE        = 5;
  Node.prototype.ENTITY_NODE                  = 6;
  Node.prototype.PROCESSING_INSTRUCTION_NODE  = 7;
  Node.prototype.COMMENT_NODE                 = 8;
  Node.prototype.DOCUMENT_NODE                = 9;
  Node.prototype.DOCUMENT_TYPE_NODE           = 10;
  Node.prototype.DOCUMENT_FRAGMENT_NODE       = 11;
  Node.prototype.NOTATION_NODE                = 12;
}

if (typeof(DOMException) == 'undefined')
{
  DOMException = function () {};
  ////////////////////////////////////////////
  // DOM EXCEPTIONS
  DOMException.prototype.INDEX_SIZE_ERR               = 1;
  DOMException.prototype.DOMSTRING_SIZE_ERR           = 2;
  DOMException.prototype.HIERARCHY_REQUEST_ERR        = 3;
  DOMException.prototype.WRONG_DOCUMENT_ERR           = 4;
  DOMException.prototype.INVALID_CHARACTER_ERR        = 5;
  DOMException.prototype.NO_DATA_ALLOWED_ERR          = 6;
  DOMException.prototype.NO_MODIFICATION_ALLOWED_ERR  = 7;
  DOMException.prototype.NOT_FOUND_ERR                = 8;
  DOMException.prototype.NOT_SUPPORTED_ERR            = 9;
  DOMException.prototype.INUSE_ATTRIBUTE_ERR          = 10;
  // introduced in DOM Level 2
  DOMException.prototype.INVALID_STATE_ERR            = 11;
  DOMException.prototype.SYNTAX_ERR                   = 12;
  DOMException.prototype.INVALID_MODIFICATION_ERR     = 13;
  DOMException.prototype.NAMESPACE_ERR                = 14;
  DOMException.prototype.INVALID_ACCESS_ERR           = 15;
  ////////////////////////////////////////////
  // CSS EXCEPTIONS
  DOMException.prototype.CSS_SYNTAX_ERR               = 0;
  DOMException.prototype.CSS_INVALID_MODIFICATION_ERR = 1;
}

if (typeof(CSSRule) == 'undefined')
{
  CSSRule = function () {};
  ////////////////////////////////////////////
  // CSS RuleTypes
  CSSRule.prototype.UNKNOWN_RULE                 = 0;
  CSSRule.prototype.STYLE_RULE                   = 1;
  CSSRule.prototype.CHARSET_RULE                 = 2;
  CSSRule.prototype.IMPORT_RULE                  = 3;
  CSSRule.prototype.MEDIA_RULE                   = 4;
  CSSRule.prototype.FONT_FACE_RULE               = 5;
  CSSRule.prototype.PAGE_RULE                    = 6;
}

function xbXMLSerializer()
{
  if (navigator.product && navigator.product == 'Gecko')
    this.serializer = new XMLSerializer();

}

xbXMLSerializer.prototype.serializeToString = function (node)
{
  var xml = null;

  if (navigator.product && navigator.product == 'Gecko')
    xml = this.serializer.serializeToString(node);
  else if (node.xml)
    xml = node.xml;

  return xml;
}


