/*
 * $Id: xbDOM2Core-wrapper.js,v 1.3 2003/09/14 21:22:26 bc Exp $
 *
 */

/* ***** BEGIN LICENSE BLOCK *****
 * The contents of this file are subject to the Mozilla Public License Version 
 * 1.1 (the "License"); you may not use this file except in compliance with 
 * the License. You may obtain a copy of the License at 
 * http://www.mozilla.org/MPL/
 * 
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 * 
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Bob Clary code.
 *
 * The Initial Developer of the Original Code is
 * Bob Clary.
 * Portions created by the Initial Developer are Copyright (C) 2000
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Bob Clary <http://bclary.com/>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 * 
 ***** END LICENSE BLOCK ***** */

function xbDOM2_wrap_Node(nativeNode)
{
  var wrappedNode = null;

  if (!nativeNode)
    return wrappedNode;

  switch(nativeNode.nodeType)
  {
  case 1:
    wrappedNode = new xbDOM2_wrapper_Element(nativeNode);
    break;

  case 2:
    wrappedNode = new xbDOM2_wrapper_Attr(nativeNode);
    break;

  case 3:
    wrappedNode = new xbDOM2_wrapper_Text(nativeNode);
    break;

  case 4:
    wrappedNode = new xbDOM2_wrapper_CDATASection(nativeNode);
    break;

  case 5:
    wrappedNode = new xbDOM2_wrapper_EntityReference(nativeNode);
    break;

  case 6:
    wrappedNode = new xbDOM2_wrapper_Entity(nativeNode);
    break;

  case 7:
    wrappedNode = new xbDOM2_wrapper_ProcessingInstruction(nativeNode);
    break;

  case 8:
    wrappedNode = new xbDOM2_wrapper_Comment(nativeNode);
    break;

  case 9:
    wrappedNode = new xbDOM2_wrapper_Document(nativeNode);
    break;

  case 10:
    wrappedNode = new xbDOM2_wrapper_DocumentType(nativeNode);
    break;

  case 11:
    wrappedNode = new xbDOM2_wrapper_DocumentFragment(nativeNode);
    break;

  case 12:
    wrappedNode = new xbDOM2_wrapper_Notation(nativeNode);
    break;

  }

  return wrappedNode;
}


function xbDOM2GetDOMImplementation()
{
  return new xbDOM2_wrapper_DOMImplementation(document.implementation);
}

// non xbDOM2_wrapper_Node related classes
_classes.registerClass('xbDOM2_wrapper_DOMImplementation');
_classes.registerClass('xbDOM2_wrapper_NodeList', 'xbArray');
_classes.registerClass('xbDOM2_wrapper_NamedNodeMap');

// xbDOM2_wrapper_Node related classes
_classes.registerClass('xbDOM2_wrapper_Node');
_classes.registerClass('xbDOM2_wrapper_DocumentFragment',      'xbDOM2_wrapper_Node');
_classes.registerClass('xbDOM2_wrapper_Document',              'xbDOM2_wrapper_Node');
_classes.registerClass('xbDOM2_wrapper_CharacterData',         'xbDOM2_wrapper_Node');
_classes.registerClass('xbDOM2_wrapper_Attr',                  'xbDOM2_wrapper_Node');
_classes.registerClass('xbDOM2_wrapper_Element',               'xbDOM2_wrapper_Node');
_classes.registerClass('xbDOM2_wrapper_Text',                  'xbDOM2_wrapper_CharacterData');
_classes.registerClass('xbDOM2_wrapper_Comment',               'xbDOM2_wrapper_CharacterData');
_classes.registerClass('xbDOM2_wrapper_CDATASection',          'xbDOM2_wrapper_Text');
_classes.registerClass('xbDOM2_wrapper_DocumentType',          'xbDOM2_wrapper_Node');
_classes.registerClass('xbDOM2_wrapper_Notation',              'xbDOM2_wrapper_Node');
_classes.registerClass('xbDOM2_wrapper_Entity',                'xbDOM2_wrapper_Node');
_classes.registerClass('xbDOM2_wrapper_EntityReference',       'xbDOM2_wrapper_Node');
_classes.registerClass('xbDOM2_wrapper_ProcessingInstruction', 'xbDOM2_wrapper_Node');

// xbDOM2_wrapper_DOMImplementation

function xbDOM2_wrapper_DOMImplementation(nativeImplementation)
{
  _classes.defineClass('xbDOM2_wrapper_DOMImplementation', _prototype_func);
  
  this.init(nativeImplementation);

  function _prototype_func()
  {
    xbDOM2_wrapper_DOMImplementation.prototype.init = function (nativeImplementation)
    {
      this.parentMethod('init')
      this.nativeImplementation = nativeImplementation;
    };

    xbDOM2_wrapper_DOMImplementation.prototype.hasFeature = hasFeature;
    function hasFeature(feature, version)
    {
      return this.nativeImplementation.hasFeature(feature, version);
    }
    
    xbDOM2_wrapper_DOMImplementation.prototype.createDocument  = createDocument;
    function createDocument(namespaceURI, qName, doctype)
    {
      return new xbDOM2_wrapper_Document(this.nativeImplementation.createDocument(namespaceURI, qName, doctype));
    }
    
    xbDOM2_wrapper_DOMImplementation.prototype.createDocumentType = createDocumentType;
    function createDocumentType(qname, publicId, systemId)
    {
      return new xbDOM2_wrapper_DocumentType(this.nativeImplementation.createDocumentType(qname, publicId, systemId));
    }
  }      
}
  
// xbDOM2_wrapper_DocumentFragment

function xbDOM2_wrapper_DocumentFragment(nativeDocumentFragment)
{
  _classes.defineClass('xbDOM2_wrapper_DocumentFragment', _prototype_func);

  this.init(nativeDocumentFragment);

  function _prototype_func()
  {
    xbDOM2_wrapper_DocumentFragment.prototype.init = init;
    function init(nativeDocumentFragment) 
    {
      this.parentMethod('init', nativeDocumentFragment)
    }
  }
}
  
// xbDOM2_wrapper_Document

function xbDOM2_wrapper_Document(nativeDocument)
{
  _classes.defineClass('xbDOM2_wrapper_Document', _prototype_func);
  
  this.init(nativeDocument);

  function _prototype_func()
  {
    xbDOM2_wrapper_Document.prototype.init = init;
    function init(nativeDocument)
    {
      this.parentMethod('init', nativeDocument);
    }
    
    xbDOM2_wrapper_Document.prototype.destroy = destroy;
    function destroy()
    {
      this.parentMethod('destroy');
    }
    
    // DOM interface

    xbDOM2_wrapper_Document.prototype.createAttribute = createAttribute;
    function createAttribute(name)
    {
      return new xbDOM2_wrapper_Attr(this.nativeNode.createAttribute(name));
    }
    
    xbDOM2_wrapper_Document.prototype.createAttributeNS = createAttributeNS;
    function createAttributeNS(namespaceURI, qualifiedName) 
    { 
      return new xbDOM2_wrapper_Attr(this.nativeNode.createAttributeNS(namespaceURI, qualifiedName));
    }
    
    xbDOM2_wrapper_Document.prototype.createCDATASection = createCDATASection;
    function createCDATASection(data)
    {
      return new xbDOM2_wrapper_CDATASection(this.nativeNode.createCDATASection(data));
    }
    
    xbDOM2_wrapper_Document.prototype.createComment = createComment;
    function createComment(data)
    {
      return new xbDOM2_wrapper_Comment(this.nativeNode.createComment(data));
    }
    
    xbDOM2_wrapper_Document.prototype.createDocumentFragment = createDocumentFragment;
    function createDocumentFragment()
    {
      return new xbDOM2_wrapper_DocumentFragment(this.nativeNode.createDocumentFragment());
    }
    
    xbDOM2_wrapper_Document.prototype.createElement = createElement;
    function createElement(tagName)
    {
      return new xbDOM2_wrapper_Element(this.nativeNode.createElement(tagName));
    }
    
    xbDOM2_wrapper_Document.prototype.createElementNS = createElementNS;
    function createElementNS(namespaceURI, qualifiedName) 
    { 
      return new xbDOM2_wrapper_Element(this.nativeNode.createElementNS(namespaceURI, qualifiedName));
    }
    
    xbDOM2_wrapper_Document.prototype.createEntityReference = createEntityReference;
    function createEntityReference(name)
    {
      return new xbDOM2_wrapper_EntityReference(this.nativeNode.createEntityReference(name));
    }
    
    xbDOM2_wrapper_Document.prototype.createProcessingInstruction  = createProcessingInstruction;
    function createProcessingInstruction(target, data)
    {
      return new xbDOM2_wrapper_ProcessingInstruction(this.nativeNode.createProcessingInstruction(target, data));
    }
    
    xbDOM2_wrapper_Document.prototype.createTextNode = createTextNode;
    function createTextNode(data)
    {
      return new xbDOM2_wrapper_Text(this.nativeNode.createTextNode(data));
    }
    
    xbDOM2_wrapper_Document.prototype.getElementsByTagName = getElementsByTagName;
    function getElementsByTagName(tagname) 
    {
      return this.nativeDocumentElement.getElementsByTagName(tagname);
    }

    xbDOM2_wrapper_Document.prototype.getElementsByTagNameNS = 
    function getElementsByTagNameNS(namespaceURI, localName) 
    { 
      // XXX: bug is not live. 
      var nativeNodeList = this.nativeDocumentElement.getElementsByTagNameNS(namespaceURI, localName); 
      return new xbDOM2_wrapper_NodeList(nativeNodeList);
    }
    
    xbDOM2_wrapper_Document.prototype.importNode = 
    function importNode(importedNode, deep) 
    {
      return new xbDOM2_wrapper_Node(this.nativeNode.importNode(importedNode.nativeNode, deep));
    }

    // getter/setter methods
    
    xbDOM2_wrapper_Document.prototype.getDocType = getDocType;
    function getDocType() 
    {
      return this.nativeNode.doctype;
    }
    
    xbDOM2_wrapper_Document.prototype.getImplementation = getImplementation;
    function getImplementation() 
    {
      return this.nativeNode.implementation;
    }
    
    xbDOM2_wrapper_Document.prototype.getDocumentElement = getDocumentElement;
    function getDocumentElement() 
    {
      return xbDOM2_wrap_Node(this.nativeNode.documentElement);
    }
    
    // non standard 
    xbDOM2_wrapper_Document.prototype.toXML = toXML;
    function toXML()
    {
      var i;
      var childNodes = this.getChildNodes();
      var length     = childNodes.getLength()
      var child;
      var s          = '';
      
      for (i = 0; i < length; i++)
      {
        child = childNodes.item(i);
        if (child.toXML)
          s += child.toXML();
      }
      return s;
    }
  }
}

// xbDOM2_wrapper_Node

function xbDOM2_wrapper_Node(nativeNode)
{
  _classes.defineClass('xbDOM2_wrapper_Node', _prototype_func);
    
  this.init(nativeNode);

  function _prototype_func()
  {
    xbDOM2_wrapper_Node.prototype.init = init;
    function init(nativeNode)
    {
      this.parentMethod('init');
      this.nativeNode = nativeNode;
    }
    
    xbDOM2_wrapper_Node.prototype.destroy = destroy; 
    function destroy()
    {
      this.nativeNode     = null;
      this.parentMethod('destroy');
    }

    xbDOM2_wrapper_Node.prototype.insertBefore = insertBefore;
    function insertBefore(newChild, refChild)
    {
      return xbDOM2_wrap_Node(this.nativeNode.insertBefore(newChild.nativeNode, refChild.nativeNode));
    }
    
    xbDOM2_wrapper_Node.prototype.replaceChild = replaceChild;
    function replaceChild(newChild, oldChild)
    {
      return xbDOM2_wrap_Node(this.nativeNode.replaceChild(newChild.nativeNode, oldChild.nativeNode));
    }

    xbDOM2_wrapper_Node.prototype.removeChild = removeChild;
    function removeChild(oldChild)
    {
      return xbDOM2_wrap_Node(this.nativeNode.removeChild(oldChild.nativeNode));
    }
    
    xbDOM2_wrapper_Node.prototype.appendChild = appendChild;
    function appendChild(newChild)
    {
      return xbDOM2_wrap_Node(this.nativeNode.appendChild(newChild.nativeNode));
    }
    
    xbDOM2_wrapper_Node.prototype.hasChildNodes  = hasChildNodes;
    function hasChildNodes() 
    {
      return this.nativeNode.hasChildNodes();
    }

    xbDOM2_wrapper_Node.prototype.cloneNode    = cloneNode;
    function cloneNode(deep)
    {
      return xbDOM2_wrap_Node(this.nativeNode.cloneNode(deep));
    }

    xbDOM2_wrapper_Node.prototype.supports = supports;
    function supports(sFeature, sVersion) 
    { 
      return this.nativeNode.supports(sFeature, sVersion);
    }

    // getter/setter methods
    
    xbDOM2_wrapper_Node.prototype.getNodeName = getNodeName;
    function getNodeName() 
    {
      return this.nativeNode.nodeName;
    }
    
    xbDOM2_wrapper_Node.prototype.getNodeValue = getNodeValue;
    function getNodeValue() 
    {
      return this.nativeNode.nodeValue;  
    }
    
    xbDOM2_wrapper_Node.prototype.setNodeValue = setNodeValue;
    function setNodeValue(nodeValue) 
    {
      this.nativeNode.nodeValue = nodeValue;
    }
    
    xbDOM2_wrapper_Node.prototype.getNodeType = getNodeType;
    function getNodeType() 
    {
      return this.nativeNode.nodeType;
    }
    
    xbDOM2_wrapper_Node.prototype.getParentNode = getParentNode;
    function getParentNode() 
    {
      return xbDOM2_wrap_Node(this.nativeNode.parentNode);
    }
    
    xbDOM2_wrapper_Node.prototype.getChildNodes = getChildNodes;
    function getChildNodes() 
    {
      return new xbDOM2_wrapper_NodeList(this.nativeNode.childNodes);
    }
    
    xbDOM2_wrapper_Node.prototype.getFirstChild = getFirstChild;
    function getFirstChild() 
    {
      return xbDOM2_wrap_Node(this.nativeNode.firstChild);
    }
    
    xbDOM2_wrapper_Node.prototype.getLastChild = getLastChild;
    function getLastChild() 
    {
      return xbDOM2_wrap_Node(this.nativeNode.lastChild);
    }
    
    xbDOM2_wrapper_Node.prototype.getPreviousSibling = getPreviousSibling;
    function getPreviousSibling() 
    {
      return xbDOM2_wrap_Node(this.nativeNode.previousSibling);
    }
    
    xbDOM2_wrapper_Node.prototype.getNextSibling = getNextSibling;
    function getNextSibling() 
    {
      return xbDOM2_wrap_Node(this.nativeNode.nextSibling);
    }
    
    xbDOM2_wrapper_Node.prototype.getAttributes = getAttributes;
    function getAttributes() 
    {
      return new xbDOM2_wrapper_NodeList(this.nativeNode.attributes);
    }
    
    xbDOM2_wrapper_Node.prototype.getOwnerDocument = getOwnerDocument;
    function getOwnerDocument() 
    {
      return new xbDOM2_wrapper_Document(this.nativeNode.ownerDocument);
    }
    
    xbDOM2_wrapper_Node.prototype.getNamespaceURI = getNamespaceURI; 
    function getNamespaceURI() 
    {
      return this.nativeNode.namespaceURI; 
    }
    
    xbDOM2_wrapper_Node.prototype.getPrefix = getPrefix;
    function getPrefix() 
    {
      return this.nativeNode.prefix; 
    }

    xbDOM2_wrapper_Node.prototype.getLocalName = getLocalName;
    function getLocalName() 
    {
      return this.nativeNode.localName; 
    }

    xbDOM2_wrapper_Node.prototype._getUserData = _getUserData;
    function _getUserData() 
    {
      return this._userdata;
    }
    
    xbDOM2_wrapper_Node.prototype._setUserData = _setUserData;
    function _setUserData(userdata) 
    {
      this._userdata = userdata; 
    }
    
    xbDOM2_wrapper_Node.prototype.isEqualTo = isEqualTo;
    function isEqualTo(node)
    {
      if (node && this.nativeNode == node.nativeNode)
        return true;
      return false;
    }

  }
}

// xbDOM2_wrapper_NodeList 

function xbDOM2_wrapper_NodeList(nativeNodeList)
{
  _classes.defineClass('xbDOM2_wrapper_NodeList', _prototype_func);
  
  this.init(nativeNodeList);

  function _prototype_func() 
  {
    xbDOM2_wrapper_NodeList.prototype.init = init;
    function init(nativeNodeList)
    {
      this.parentMethod('init');
      this.nativeNodeList = nativeNodeList;
    }

    xbDOM2_wrapper_NodeList.prototype.item = item;
    function item(i)
    {
      return xbDOM2_wrap_Node(this.nativeNodeList.item(i));
    }
    
    xbDOM2_wrapper_NodeList.prototype.getLength = getLength;
    function getLength()
    {
      return this.nativeNodeList.length;
    }
    
  }
}


// xbDOM2_wrapper_NamedNodeMap

function xbDOM2_wrapper_NamedNodeMap(nativeNodeMap)
{
  _classes.defineClass('xbDOM2_wrapper_NamedNodeMap', _prototype_func);

  this.init(nativeNodeMap);    

  function _prototype_func()
  {
    xbDOM2_wrapper_NamedNodeMap.prototype.init = init;
    function init(nativeNodeMap)
    {
      this.parentMethod('init');
      this.nativeNodeMap = nativeNodeMap;
    }
    
    xbDOM2_wrapper_NamedNodeMap.prototype.destroy = destroy;
    function destroy()
    {
      this.nativeNodeMap = null;
      this.parentMethod('destroy');
    }
        
    xbDOM2_wrapper_NamedNodeMap.prototype.getNamedItem = getNamedItem; 
    function getNamedItem(name) 
    {
      return xbDOM2_wrap_Node(this.nativeNodeMap.getNamedItem(name));
    }
    
    xbDOM2_wrapper_NamedNodeMap.prototype.getNamedItemNS = getNamedItemNS;
    function getNamedItemNS(namespaceURI, name)
    {
      return xbDOM2_wrap_Node(this.nativeNodeMap.getNamedItemNS(namespaceURI, name));
    }
    
    xbDOM2_wrapper_NamedNodeMap.prototype.item = item;
    function item(index)
    {
      return xbDOM2_wrap_Node(this.nativeNodeMap.item(index));
    }
    
    xbDOM2_wrapper_NamedNodeMap.prototype.removeNamedItem = removeNamedItem;
    function removeNamedItem(name)
    {
      return xbDOM2_wrap_Node(this.nativeNodeMap.removeNamedItem(name));
    }

    xbDOM2_wrapper_NamedNodeMap.prototype.removeNamedItemNS = removeNamedItemNS;
    function removeNamedItemNS(namespaceURI, name)
    {
      return xbDOM2_wrap_Node(this.nativeNodeMap.removeNamedItemNS(namespaceURI, name));
    }
    
    xbDOM2_wrapper_NamedNodeMap.prototype.setNamedItem = setNamedItem;
    function setNamedItem(node)
    {
      return xbDOM2_wrap_Node(this.nativeNodeMap.setNamedItemNS(node.nativeNode));
    }

    xbDOM2_wrapper_NamedNodeMap.prototype.setNamedItemNS = setNamedItemNS;
    function setNamedItemNS(node)
    {
      //XXX bug NS?
      return xbDOM2_wrap_Node(this.nativeNodeMap.setNamedItemNS(node.nativeNode));
    }

    // getter/setter methods
    xbDOM2_wrapper_NamedNodeMap.prototype.getLength  = getLength;
    function getLength() 
    {
      return this.nativeNodeMap.length;
    }
    
  }
}

// xbDOM2_wrapper_CharacterData

function xbDOM2_wrapper_CharacterData(nativeCharacterData)
{
  _classes.defineClass('xbDOM2_wrapper_CharacterData', _prototype_func);
    
  this.init(nativeCharacterData);

  function _prototype_func()
  {
    xbDOM2_wrapper_CharacterData.prototype.init = init;
    function init(nativeCharacterData) 
    {
      this.parentMethod('init', nativeCharacterData);  
    }
        
    xbDOM2_wrapper_CharacterData.prototype.destroy = destroy;
    function destroy()
    {
      this.parentMethod('destroy');
    }

    // DOM  interface
    
    xbDOM2_wrapper_CharacterData.prototype.appendData = appendData;
    function appendData(arg)
    {
      this.nativeNode.appendData(arg);
    }
    
    xbDOM2_wrapper_CharacterData.prototype.insertData = insertData;
    function insertData(offset, arg)
    {
      this.nativeNode.insertData(offset, arg);
    }
    
    xbDOM2_wrapper_CharacterData.prototype.deleteData = deleteData;
    function deleteData(offset, count)
    {
      this.nativeNode.deleteData(offset, count);
    }
    
    xbDOM2_wrapper_CharacterData.prototype.replaceData = replaceData;
    function replaceData(offset, count, arg)
    {
      this.nativeNode.replaceData(offset, count, arg);
    }

    xbDOM2_wrapper_CharacterData.prototype.substringData = substringData;
    function substringData(offset, count) 
    {
      return this.nativeNode.substringData(offset, count);
    }

    // getter/setter methods
    
    xbDOM2_wrapper_CharacterData.prototype.getData = getData;
    function getData() 
    {
      return this.nativeNode.data;
    }
    
    xbDOM2_wrapper_CharacterData.prototype.setData = setData;
    function setData(data) 
    {
      this.nativeNode.data = data;
    }
    
    xbDOM2_wrapper_CharacterData.prototype.getLength = getLength;
    function getLength() 
    {
      return this.nativeNode.length;
    }
    
  }
}

// xbDOM2_wrapper_Attr

function xbDOM2_wrapper_Attr(nativeAttr)
{
  _classes.defineClass('xbDOM2_wrapper_Attr', _prototype_func);
  
  this.init(nativeAttr);

  function _prototype_func()
  {
    xbDOM2_wrapper_Attr.prototype.init = init;
    function init(nativeAttr)
    {
      this.parentMethod('init', nativeAttr);
    }
    
    xbDOM2_wrapper_Attr.prototype.destroy    = destroy;
    function destroy()
    {
      this.parentMethod('destroy');
    }

    xbDOM2_wrapper_Attr.prototype.getName = getName;
    function getName() 
    {
      return this.nativeNode.name;
    }
    
    xbDOM2_wrapper_Attr.prototype.getSpecified = getSpecified;
    function getSpecified() 
    {
      return this.nativeNode.specified;
    }
    
    xbDOM2_wrapper_Attr.prototype.getValue = getValue;
    function getValue() 
    {
      return this.nativeNode.value;
    }
    
    xbDOM2_wrapper_Attr.prototype.getOwnerElement = getOwnerElement;
    function getOwnerElement() 
    {
      return this.nativeNode.ownerElement;
    }
    
    xbDOM2_wrapper_Attr.prototype.setValue = setValue;
    function setValue(value) 
    {
      this.nativeNode.nodeValue = value;
    }
  }
}

// xbDOM2_wrapper_Element

function xbDOM2_wrapper_Element(nativeElement)
{
  _classes.defineClass('xbDOM2_wrapper_Element', _prototype_func);
  
  this.init(nativeElement);

  function _prototype_func()
  {
    xbDOM2_wrapper_Element.prototype.init = init;
    function init(nativeElement)
    {
      this.parentMethod('init', nativeElement);
    }
    
    xbDOM2_wrapper_Element.prototype.destroy = destroy;
    function destroy() 
    {
      this.parentMethod('destroy');
    }

    // DOM interface
    
    xbDOM2_wrapper_Element.prototype.getAttribute = getAttribute;
    function getAttribute(name) 
    {
      return this.nativeNode.attributes.getNamedItem(name);
    }
    
    xbDOM2_wrapper_Element.prototype.getAttributeNS = 
    function getAttributeNS(namespaceURI, localName) 
    {
      return this.nativeNode.attributes.getNamedItemNS(namespaceURI, localName);
    }
    
    xbDOM2_wrapper_Element.prototype.getAttributeNode = getAttributeNode;
    function getAttributeNode(name) 
    {
      return this.nativeNode.attributes.getNamedItem(name);
    }
    
    xbDOM2_wrapper_Element.prototype.getAttributeNodeNS = getAttributeNodeNS;
    function getAttributeNodeNS(namespaceURI, localName) 
    {
      return this.nativeNode.attributes.getNamedItemNS(namespaceURI, localName);
    }
    
    xbDOM2_wrapper_Element.prototype.getElementsByTagName = getElementsByTagName;
    function getElementsByTagName(tagname)
    {
      return new xbDOM2_wrapper_NodeList(this.nativeNode.getElementsByTagName(tagname));
    }
    
    xbDOM2_wrapper_Element.prototype.getElementsByTagNameNS = getElementsByTagNameNS;
    function getElementsByTagNameNS(namespaceURI, localName) 
    {
      return new xbDOM2_wrapper_NodeList(this.nativeNode.getElementsByTagName(namespaceURI, localName));
    }

    xbDOM2_wrapper_Element.prototype.hasAttribute = hasAttribute;
    function hasAttribute(name)
    {
      return this.nativeNode.hasAttribute(name);
    }

    xbDOM2_wrapper_Element.prototype.hasAttributeNS = hasAttributeNS;
    function hasAttributeNS(namespaceURI, localName)
    {
      return this.nativeNode.hasAttributeNS(namespaceURI, localName);
    }

    xbDOM2_wrapper_Element.prototype.removeAttribute = removeAttribute;
    function removeAttribute(name) 
    {
      this.nativeNode.removeAttribute(name);
    }
    
    xbDOM2_wrapper_Element.prototype.removeAttributeNS = removeAttributeNS;
    function removeAttributeNS(namespaceURI, localName) 
    { 
      this.nativeNode.removeAttributeNS(namespaceURI, localName);
    }
    
    xbDOM2_wrapper_Element.prototype.removeAttributeNode = removeAttributeNode;
    function removeAttributeNode(oldAttr) 
    {
      this.nativeNode.removeAttributeNode(oldAttr.nativeNode);
    }
    
    xbDOM2_wrapper_Element.prototype.setAttribute = setAttribute;
    function setAttribute(name, value)
    {
      this.nativeNode.setAttribute(name, value);
    }
    
    xbDOM2_wrapper_Element.prototype.setAttributeNS = setAttributeNS;
    function setAttributeNS(namespaceURI, localName, value) 
    { 
      this.nativeNode.setAttributeNS(namespaceURI, localName, value);
    }
    
    xbDOM2_wrapper_Element.prototype.setAttributeNode = setAttributeNode;
    function setAttributeNode(newAttr) 
    {
      this.nativeNode.setAttributeNode(newAttr.nativeNode);
    }
    
    xbDOM2_wrapper_Element.prototype.setAttributeNodeNS = setAttributeNodeNS;
    function setAttributeNodeNS(newAttr) 
    { 
      this.nativeNode.setAttributeNodeNS(newAttr.nativeNode);
    }
    
    xbDOM2_wrapper_Element.prototype.normalize = normalize;
    function normalize() 
    {
      this.nativeNode.normalize();
    }
    
    xbDOM2_wrapper_Element.prototype.toXML = toXML;
    function toXML()
    {
      var i;
      var s = '';
        
      s = '<' + this.getNodeName();
        
      var attr;
      var attributes = this.getAttributes();
      var length     = attributes.getLength();

      for (i = 0; i < length; i++)
      {
        attr = attributes.item(i);
        if (attr.getNodeValue())
          s += ' ' + attr.getNodeName() + '=' + '"' + attr.getNodeValue() + '"';
      }
      s += '>';

      var childNodes = this.getChildNodes();
      var length = childNodes.getLength();

      for (i = 0; i < length; i++)
      {
        s += childNodes.item(i).toXML();
      }
            
      s += '</' + this.getNodeName() + '>';
            
      return s;
    }
    
    // getter/setter methods
    
    xbDOM2_wrapper_Element.prototype.getTagName = getTagName;
    function getTagName() 
    {
      return this.nativeNode.tagName;
    }
    
  }
}

// xbDOM2_wrapper_Text

function xbDOM2_wrapper_Text(nativeText)
{
  _classes.defineClass('xbDOM2_wrapper_Text', _prototype_func);
    
  this.init(nativeText);

  function _prototype_func()
  {
    xbDOM2_wrapper_Text.prototype.init = init;
    function init(nativeText)
    {
      this.parentMethod('init', nativeText);
    }
    
    xbDOM2_wrapper_Text.prototype.destroy = destroy;
    function destroy() 
    {
      this.parentMethod('destroy');
    }
    
    xbDOM2_wrapper_Text.prototype.splitText  = splitText;
    function splitText(offset)
    {
      return this.nativeNode.splitText(offset);
    }
    
    // convert to XML text
    
    xbDOM2_wrapper_Text.prototype.toXML = toXML;
    function toXML() 
    {
      return  this.nativeNode.nodeValue;
    }
  }
}

// xbDOM2_wrapper_Comment

function xbDOM2_wrapper_Comment(nativeComment)
{
  _classes.defineClass('xbDOM2_wrapper_Comment', _prototype_func);
    
  this.init(nativeComment);

  function _prototype_func()
  {
    xbDOM2_wrapper_Comment.prototype.init = init;
    function init(nativeComment)
    {
      this.parentMethod('init', nativeComment);
    }
    
    xbDOM2_wrapper_Comment.prototype.destroy    = destroy
    function destroy() 
    {
      this.parentMethod('destroy');
    }
    
    // convert to XML text
    xbDOM2_wrapper_Comment.prototype.toXML      = toXML;
    function toXML()  
    {
      return  '<!--' + this.nativeNode.nodeValue + '-->';
    }
  }
}

// xbDOM2_wrapper_CDATASection

function xbDOM2_wrapper_CDATASection(nativeCDATASection)
{
  _classes.defineClass('xbDOM2_wrapper_CDATASection', _prototype_func);
    
  this.init(nativeCDATASection);

  function _prototype_func()
  {
    xbDOM2_wrapper_CDATASection.prototype.init = init;
    function init(nativeCDATASection)
    {
      this.parentMethod('init', nativeCDATASection);
    }
    
    xbDOM2_wrapper_CDATASection.prototype.destroy = destroy;
    function destroy() 
    {
      this.parentMethod('destroy');
    }
    
    // convert to XML text
    
    xbDOM2_wrapper_CDATASection.prototype.toXML    = toXML;
    function toXML() 
    {
      return '<![CDATA[' + this.nativeNode.nodeValue + ']]>';
    }
  }
}

// xbDOM2_wrapper_DocumentType

function xbDOM2_wrapper_DocumentType(nativeDocumentType)
{
  _classes.defineClass('xbDOM2_wrapper_DocumentType', _prototype_func);
  
  this.init(nativeDocumentType);
  
  function _prototype_func()
  {
    // constructor/destructor
    xbDOM2_wrapper_DocumentType.prototype.init = init;
    function init(nativeDocumentType)
    {
      this.parentMethod('init', nativeDocumentType);
    }
    
    // need to override supports since the node version
    // either requires an ownerDocument or an implementation
    // newly createdDocumentTypes have neither.
    xbDOM2_wrapper_DocumentType.prototype.supports = supports;
    function supports(feature, version)
    {
      return this.nativeNode.supports(feature, version);
    }

    // getter/setter methods
    
    xbDOM2_wrapper_DocumentType.prototype.getName = getName;
    function getName() 
    {
      return this.nativeNode.name;
    }
    
    xbDOM2_wrapper_DocumentType.prototype.getEntities  = getEntities;
    function getEntities() 
    {
      return this.nativeNode.entities;
    }
    
    xbDOM2_wrapper_DocumentType.prototype.getNotations  = getNotations;
    function getNotations() 
    {
      return this.nativeNode.notations;
    }
    
    xbDOM2_wrapper_DocumentType.prototype.getPublicID  = getPublicID;
    function getPublicID() 
    {
      return this.nativeNode.publicId;
    }
    
    xbDOM2_wrapper_DocumentType.prototype.getSystemID  = getSystemID;
    function getSystemID() 
    {
      return this.nativeNode.systemId;
    }
    
  }
}

// xbDOM2_wrapper_Notation

function xbDOM2_wrapper_Notation(nativeNotation)
{
  _classes.defineClass('xbDOM2_wrapper_Notation', _prototype_func);

  this.init(nativeNotation);
    
  function _prototype_func()
  {
    // constructor/destructor
    xbDOM2_wrapper_Notation.prototype.init = init;
    function init(nativeNotation)
    {
      this.parentMethod('init', nativeNotation);
    }
    
    // getter/setter methods
    
    xbDOM2_wrapper_Notation.prototype.getPublicId = getPublicId;
    function getPublicId() 
    {
      return this.nativeNode.publicId;
    }
    
    xbDOM2_wrapper_Notation.prototype.getSystemId = getSystemId;
    function getSystemId() 
    {
      return this.nativeNode.systemId;
    }
    
  }
}

// xbDOM2_wrapper_Entity

function xbDOM2_wrapper_Entity(nativeEntity)
{
  _classes.defineClass('xbDOM2_wrapper_Entity', _prototype_func);
  
  this.init(nativeEntity);
  
  function _prototype_func()
  {
    // constructor/destructor
    xbDOM2_wrapper_Entity.prototype.init = init;
    function init(nativeEntity)
    {
      this.parentMethod('init', nativeEntity);
    }
    
    // getter/setter methods
    
    xbDOM2_wrapper_Entity.prototype.getPublicId  = getPublicId;
    function getPublicId()   
    {
      return this.nativeNode.publicId;
    }
    
    xbDOM2_wrapper_Entity.prototype.getSystemId = getSystemId;
    function getSystemId() 
    {
      return this.nativeNode.systemId;
    }
    
    xbDOM2_wrapper_Entity.prototype.getNotationName  = getNotationName;
    function getNotationName() 
    {
      return this.nativeNode.notationName;
    }
    
  }
}


// xbDOM2_wrapper_EntityReference

function xbDOM2_wrapper_EntityReference(nativeEntityReference)
{
  _classes.defineClass('xbDOM2_wrapper_EntityReference', _prototype_func);
  
  this.init(nativeEntityReference);
  
  function _prototype_func()
  {
    // constructor/destructor
    xbDOM2_wrapper_EntityReference.prototype.init = init;
    function init(nativeEntityReference)
    {
      this.parentMethod('init', nativeEntityReference);
    }

    xbDOM2_wrapper_EntityReference.prototype.getName  = getName;
    function getName() 
    { 
      return this.nativeNode.nodeName; 
    }
    
    xbDOM2_wrapper_EntityReference.prototype.toXML = toXML;
    function toXML()
    {
      return '&' + this.nativeNode.nodeName + ';';
    }
  }
}

// xbDOM2_wrapper_ProcessingInstruction

function xbDOM2_wrapper_ProcessingInstruction(nativePI)
{
  _classes.defineClass('xbDOM2_wrapper_ProcessingInstruction', _prototype_func);
  
  this.init(nativePI);
  
  function _prototype_func()
  {
    // constructor/destructor
    xbDOM2_wrapper_ProcessingInstruction.prototype.init  = init;
    function init(nativePI)
    {
      this.parentMethod('init', nativePI);
    }
    
    // getter/setter methods
    
    xbDOM2_wrapper_ProcessingInstruction.prototype.getTarget = getTarget;
    function getTarget() 
    {
      return this.nativeNode.target;
    }
    
    xbDOM2_wrapper_ProcessingInstruction.prototype.getData = getData;
    function getData() 
    {
      return this.nativeNode.data;
    }
    
    xbDOM2_wrapper_ProcessingInstruction.prototype.setData = setData;
    function setData(data) 
    {
      this.nativeNode.nodeValue = data;
    }
    
    // convert to XML text
    
    xbDOM2_wrapper_ProcessingInstruction.prototype.toXML = toXML;
    function toXML()
    {
      var data = this.getData();
      var target = this.getTarget();
      var s = '<?' + target;
      if (data)
        s += ' ' + data;
      s += '?>';
      return s;
    }

  }
}

// eof: xbDOM2_wrapper_core.js
