/*
 * $Id: xbEvents-ie.js,v 1.2 2003/09/14 21:22:26 bc Exp $
 *
 */

// Implement DOM Events for Internet Explorer

/* ***** BEGIN LICENSE BLOCK *****
 * The contents of this file are subject to the Mozilla Public License Version 
 * 1.1 (the "License"); you may not use this file except in compliance with 
 * the License. You may obtain a copy of the License at 
 * http://www.mozilla.org/MPL/
 * 
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 * 
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Bob Clary code.
 *
 * The Initial Developer of the Original Code is
 * Bob Clary.
 * Portions created by the Initial Developer are Copyright (C) 2000
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Bob Clary <http://bclary.com/>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 * 
 ***** END LICENSE BLOCK ***** */

if (!(document.all && document.getElementById))
{
  throw new xbException('This file is only used by Internet Explorer 5', 'xbEvents.js', '');
}

_classes.registerClass('xbEventDispatcher');
  
function xbEventDispatcher(windowRef, object, useCapture)
{
  _classes.defineClass('xbEventDispatcher', _prototype_func);
    
  this.init(windowRef, object, useCapture);
    
  function _prototype_func()
  {
    xbEventDispatcher.prototype.init = init;
    function init(windowRef, object, useCapture)
    {
      this.object    = object;
      this.windowRef  = windowRef;
      this.useCapture  = useCapture;
      
      if (useCapture)
        throw new xbException('useCapture not supported', 'xbEvents.js', 'xbEventDispatcher::init'); 
    }
      
    xbEventDispatcher.prototype.handleEvent = handleEvent;
    function handleEvent()
    {
      var windowsEvent    = this.xbeventDispatcher.windowRef.event;
      var windowsEventType  = windowsEvent.type;
      var useCapture      = this.xbeventDispatcher.useCapture;
      var xbevent        = null;
    
      if (!this.eventListeners)
        throw( new xbException('This object has no event listeners', 'xbEvents.js', 'xbEventDispatcher::handleEvent'));
          
      switch(windowsEventType)
      {
      case 'load':
        xbevent = new xbEvent(windowsEventType, false, false);
        break;
          
      case 'unload':
        xbevent = new xbEvent(windowsEventType, false, false);
        break;
          
      case 'abort':
        xbevent = new xbEvent(windowsEventType, true, false);
        break;
          
      case 'error':
        xbevent = new xbEvent(windowsEventType, true, false);
        break;
          
      case 'select':
        xbevent = new xbEvent(windowsEventType, true, false);
        break;
          
      case 'change':
        xbevent = new xbEvent(windowsEventType, true, false);
        break;
          
      case 'submit':
        xbevent = new xbEvent(windowsEventType, true, true);
        break;
          
      case 'reset':
        xbevent = new xbEvent(windowsEventType, true, false);
        break;
          
      case 'focus':
        xbevent = new xbEvent(windowsEventType, false, false);
        break;
          
      case 'blur':
        xbevent = new xbEvent(windowsEventType, false, false);
        break;
          
      case 'click':
      case 'mousedown':
      case 'mouseup':
      case 'mousemove':
        xbevent = new xbMouseEvent(windowsEventType, true, true, window, 0, windowsEvent.screenX, windowsEvent.screenY, windowsEvent.clientX, windowsEvent.clientY, windowsEvent.ctrlKey, windowsEvent.altKey, windowsEvent.shiftKey, windowsEvent.metaKey, windowsEvent.button, windowsEvent.srcElement);
        break          

      case 'mouseover':
        xbevent = new xbMouseEvent(windowsEventType, true, true, window, 0, windowsEvent.screenX, windowsEvent.screenY, windowsEvent.clientX, windowsEvent.clientY, windowsEvent.ctrlKey, windowsEvent.altKey, windowsEvent.shiftKey, windowsEvent.metaKey, windowsEvent.button, windowsEvent.fromElement);
        break          

      case 'mouseout':
        xbevent = new xbMouseEvent(windowsEventType, true, true, window, 0, windowsEvent.screenX, windowsEvent.screenY, windowsEvent.clientX, windowsEvent.clientY, windowsEvent.ctrlKey, windowsEvent.altKey, windowsEvent.shiftKey, windowsEvent.metaKey, windowsEvent.button, windowsEvent.toElement);
        break          

      case 'resize':
        xbevent = new xbUIEvent(windowsEventType, true, false, window, null);
        break;

      case 'focusin':
        xbevent = new xbUIEvent(windowsEventType, false, false, window, null);
        break;

      case 'focusout':
        xbevent = new xbUIEvent(windowsEventType, false, false, window, null);
        break;

      case 'gainselection':
        xbevent = new xbUIEvent(windowsEventType, true, false, window, null);
        break;

      case 'loselection':
        xbevent = new xbUIEvent(windowsEventType, true, false, window, null);
        break;

      case 'activate':
        xbevent = new xbUIEvent(windowsEventType, true, true, window, null);
        break;

      case 'keypress':
      case 'keydown':
      case 'keyup':
        // substituting windowsEvent.keyCode for windowsEvent.charChode. windowsEvent.charCode should be unicode rep of key...
        xbevent = new xbKeyEvent(windowsEventType, true, true, windowsEvent.ctrlKey, windowsEvent.altKey, windowsEvent.metaKey, windowsEvent.keyCode, windowsEvent.keyCode, view)
        break;

      default:
        throw(new xbException('event type ' + windowsEventType + ' not supported', 'xbEvents.js', 'xbEventDispatcher::handleEvent'));
      }
      
      xbevent.target = windowsEvent.srcElement;
      xbevent.currentNode = windowsEvent.srcElement;
      xbevent.windowRef = this.xbeventDispatcher.windowRef;

      if (!xbevent.canBubble)
        xbevent.preventBubble();

      var listeners = this.eventListeners[windowsEventType];
      var i;
      var listenerResult;
      var eventResult = true;
        
      for (i = 0; i < listeners.length; i++)
      {
        listenerResult = listeners[i](xbevent);
        if (typeof(listenerResult) == 'undefined')
          listenerResult = false;
          
        eventResult &= listenerResult;
      }
      
      if (xbevent._propagate)
      {
      }
      
      return eventResult;
    }
  }
}

_classes.registerClass('xbEvent');

function xbEvent(eventType, canBubble, cancelable)
{
  _classes.defineClass('xbEvent', _prototype_func);
  
  this.init(eventType, canBubble, cancelable);
  
  function _prototype_func()
  {
    xbEvent.prototype.BUBBLING_PHASE  = 1;
    xbEvent.prototype.CAPTURING_PHASE  = 2;
    xbEvent.prototype.AT_TARGET_PHASE  = 3;
    
    xbEvent.prototype.init = init;
    function init(eventType, canBubble, cancelable)
    {
      this.type      = eventType;
      this.target      = null;
      this.currentNode  = null;
      this.eventPhase    = null;
      this.bubbles    = canBubble;
      this.cancelable    = cancelable;
      this._propagate    = true;
      this.windowRef      = null;
    }
    
    xbEvent.prototype.stopPropagation = stopPropagation;
    function stopPropagation()
    {
      this._propagate    = false;
      this.preventBubble();
    }
    
    xbEvent.prototype.preventBubble = preventBubble;
    function preventBubble()
    {
      this.target.cancelBubble = true;
    }
    
    xbEvent.prototype.preventCapture = preventCapture;
    function preventCapture()
    {
    }
    
    xbEvent.prototype.preventDefault = preventDefault;
    function preventDefault()
    {
      if (this.cancelable)
        this.windowRef.event.returnValue = false;
    }
    
    xbEvent.prototype.initEvent = initEvent;
    function initEvent(eventType, canBubble, cancelable)
    {
      this.init(eventType, canBubble, cancelable);
    }
  }
}

_classes.registerClass('xbUIEvent', 'xbEvent');

function xbUIEvent(eventType, canBubble, cancelable, view, detail)
{
  _classes.defineClass('xbUIEvent', _prototype_func);
  
  this.init(eventType, canBubble, cancelable, view, detail);
  
  function _prototype_func()
  {
    xbUIEvent.prototype.init = init;
    function init(eventType, canBubble, cancelable, view, detail)
    {
      this.parentMethod('init', eventType, canBubble, cancelable);
      this.view = view;
      this.detail = detail;
    }
    
    xbUIEvent.prototype.initUIEvent = initUIEvent;
    function initUIEvent(eventType, canBubble, cancelable, view, detail)
    {
      this.init(eventType, canBubble, cancelable, view, detail);
    }
  }
}

_classes.registerClass('xbMouseEvent', 'xbUIEvent');

function xbMouseEvent(eventType, canBubble, cancelable, view, detail, screenX, screenY, clientX, clientY, ctrlKey, altKey, shiftKey, metaKey, button, relatedNode)
{
  _classes.defineClass('xbMouseEvent', _prototype_func);
  
  this.init(eventType, canBubble, cancelable, view, detail, screenX, screenY, clientX, clientY, ctrlKey, altKey, shiftKey, metaKey, button, relatedNode);
                                    
  function _prototype_func()
  {
    xbMouseEvent.prototype.init = init;
    function init(eventType, canBubble, cancelable, view, detail, screenX, screenY, clientX, clientY, ctrlKey, altKey, shiftKey, metaKey, button, relatedNode)
    {
      this.parentMethod('init', eventType, canBubble, cancelable, view, detail);
      this.screenX  = screenX;
      this.screenY  = screenY;
      this.clientX  = clientX;
      this.clientY  = clientY;
      this.ctrlKey  = ctrlKey;
      this.altKey   = altKey;
      this.shiftKey = shiftKey;
      this.metaKey  = metaKey;
      this.button   = button;
      this.relatedNode = relatedNode;
    }

    xbMouseEvent.prototype.initMouseEvent = initMouseEvent;
    function initMouseEvent(eventType, canBubble, cancelable, view, detail, screenX, screenY, clientX, clientY, ctrlKey, altKey, shiftKey, metaKey, button, relatedNode)
    {
      this.init(eventType, canBubble, cancelable, view, detail, screenX, screenY, clientX, clientY, ctrlKey, altKey, shiftKey, metaKey, button, relatedNode);
    }
  }                    
}

_classes.registerClass('xbKeyEvent', 'xbUIEvent');

function xbKeyEvent(eventType, canBubble, cancelable, ctrlKey, altKey, shiftKey, metaKey, keyCode, charCode, view)
{
  _classes.defineClass('xbKeyEvent', _prototype_func);
  
  this.init(eventType, canBubble, cancelable, ctrlKey, altKey, shiftKey, metaKey, keyCode, charCode, view);
  
  function _prototype_func()
  {
    xbKeyEvent.prototype.init = init;
    function init(eventType, canBubble, cancelable, ctrlKey, altKey, shiftKey, metaKey, keyCode, charCode, view)
    {
      this.parentMethod('init', eventType, canBubble, cancelable, view, 0);
      this.ctrlKey  = ctrlKey;
      this.altKey    = altKey;
      this.shiftKey   = shiftKey;
      this.metaKey  = metaKey;
      this.keyCode  = keyCode;
      this.charCode  = charCode;
      this.view    = view;
    }
  }
}
  
