/*
 * $Id: xbEventsAPI.js,v 1.8 2003/09/14 21:15:14 bc Exp $
 *
 */

// Implement DOM Events for Internet Explorer

/* ***** BEGIN LICENSE BLOCK *****
 * The contents of this file are subject to the Mozilla Public License Version 
 * 1.1 (the "License"); you may not use this file except in compliance with 
 * the License. You may obtain a copy of the License at 
 * http://www.mozilla.org/MPL/
 * 
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 * 
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Bob Clary code.
 *
 * The Initial Developer of the Original Code is
 * Bob Clary.
 * Portions created by the Initial Developer are Copyright (C) 2000
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Bob Clary <http://bclary.com/>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 * 
 ***** END LICENSE BLOCK ***** */

registerFile('xbEventsAPI.js', 'base.js, xbObjects.js');

function AddEventListener(windowRef, object, evtName, evtHandler, useCapture)
{
  if (object.addEventListener)
    object.addEventListener(evtName, evtHandler, useCapture);
  else
  {
    if (!object.eventListeners)
      object.eventListeners = new Object();
      
    if (!object.eventListeners[evtName])
    {
      object.eventListeners[evtName] = new Array();
      // note that when handleEvent is called, it will be as a method
      // of object. Save the xbeventDispatcher as a property of object
      // so that we can retrieve the proper window object in order to 
      // get the correct event object.
      var xbeventDispatcher = new xbEventDispatcher(windowRef, object, useCapture);
      object['on' + evtName] = xbeventDispatcher.handleEvent;
      object.xbeventDispatcher = xbeventDispatcher;
    }
      
    var listeners = object.eventListeners[evtName];
    
    listeners[listeners.length] = evtHandler;
  }
}

function RemoveEventListener(windowRef, object, evtName, evtHandler, useCapture)
{
  if (object.removeEventListener)
    object.removeEventListener(evtName, evtHandler, useCapture);
  else
  {
    if (!object.eventListeners)
      object.eventListeners = new Object();
      
    if (!object.eventListeners[evtName])
    {
      object.eventListeners[evtName] = new Array();
      // note that when handleEvent is called, it will be as a method
      // of object. Save the xbeventDispatcher as a property of object
      // so that we can retrieve the proper window object in order to 
      // get the correct event object.
      var xbeventDispatcher = new xbEventDispatcher(windowRef, object, useCapture);
      object['on' + evtName] = xbeventDispatcher.handleEvent;
      object.xbeventDispatcher = xbeventDispatcher;
    }
      
    var listeners = object.eventListeners[evtName];
    
    var i;
    
    for (i = 0; i < listeners.length; i++)
    {
      if (listeners[i] == evtHandler)
        listeners[i] = noop;
    }
  }
}

