/*
 * $Id: xbException.js,v 1.3 2003/09/14 21:22:26 bc Exp $
 *
 */

/* ***** BEGIN LICENSE BLOCK *****
 * The contents of this file are subject to the Mozilla Public License Version 
 * 1.1 (the "License"); you may not use this file except in compliance with 
 * the License. You may obtain a copy of the License at 
 * http://www.mozilla.org/MPL/
 * 
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 * 
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Bob Clary code.
 *
 * The Initial Developer of the Original Code is
 * Bob Clary.
 * Portions created by the Initial Developer are Copyright (C) 2000
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Bob Clary <http://bclary.com/>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 * 
 ***** END LICENSE BLOCK ***** */

_classes.registerClass('xbException');

function xbException(errorMessage, errorFile, errorFunction, exception)
{
  _classes.defineClass('xbException', _prototype_func);
  
  this.init(errorMessage, errorFile, errorFunction, exception);
  
  function _prototype_func()
  {
    function init(errorMessage, errorFile, errorFunction, exception)
    {
      // turn off error handling inside xbExceptions
      var oldonerror = null;
      if (typeof(window.onerror) == 'function')
        oldonerror = window.onerror;
      window.onerror = null;

      if (typeof(exception) == 'object' && typeof(exception.isa) != 'undefined' && exception.isa == 'xbException')
      {
        this.errorMessage  = exception.errorMessage;
        this.errorFile = exception.errorFile;
        this.errorFunction = exception.errorFunction;
        this.nativeMessage  = exception.nativeMessage;
        this.nativeException = exception.nativeException;
      }
      else
      {
        this.errorMessage  = errorMessage;
        this.errorFile = errorFile;
        this.errorFunction = errorFunction;
        this.nativeMessage  = '';

        if (typeof(exception) == 'object')
        {
          var p;
              
          /*
          This causes exceptions in some cases related to
          XPCWrappedNative_NoHelper in Gecko 0.9.5+
          related to permission denied to access filename,
          lineNumber, columnNumber. Revert to the public toString()
          interface.

          for (p in exception)
            if (typeof(exception[p]) == 'string' || typeof(exception[p]) == 'number')
              this.nativeMessage += p + ' = ' + exception[p] + ' ';
          */
          this.nativeMessage = exception + '';
              
          this.nativeException = exception;
        }
      }
      // turn error handlng back on
      window.onerror = oldonerror;
    }
    xbException.prototype.init = init;
    
    function toString()
    {
      // turn off error handling inside xbExceptions
      var oldonerror = null;
      if (typeof(window.onerror) == 'function')
        oldonerror = window.onerror;
      window.onerror = null;

      var s = 'xbException(' + this.errorFile + ' : ' + this.errorFunction + ') ' +
              this.errorMessage + ' / ' + this.nativeMessage;
      // turn error handlng back on
      window.onerror = oldonerror;
      return s;
    }
    xbException.prototype.toString = toString;
  }
}
