/*
 * $Id: xbLibrary.js,v 1.3 2003/09/14 21:22:26 bc Exp $
 *
 */

/* ***** BEGIN LICENSE BLOCK *****
 * The contents of this file are subject to the Mozilla Public License Version 
 * 1.1 (the "License"); you may not use this file except in compliance with 
 * the License. You may obtain a copy of the License at 
 * http://www.mozilla.org/MPL/
 * 
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 * 
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Bob Clary code.
 *
 * The Initial Developer of the Original Code is
 * Bob Clary.
 * Portions created by the Initial Developer are Copyright (C) 2000
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Bob Clary <http://bclary.com/>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 * 
 ***** END LICENSE BLOCK ***** */

if (!document.getElementById || navigator.userAgent.indexOf('Opera') != -1)
{
  // assign error handler for downlevel browsers
  // Note until Opera improves it's overall support
  // for JavaScript and the DOM, it must be considered downlevel

  window.onerror = defaultOnError;
  
  function defaultOnError(msg, url, line)
  {
    // handle bug in NS6.1, N6.2
    // where an Event is passed to error handlers
    if (typeof(msg) != 'string')
    {
        msg = 'unknown error';
    }
    if (typeof(url) != 'string')
    {
        url = document.location;
    }

    // customize this for your site
    if (top.location.href.indexOf(xblibrary.path + '/errors/') == -1)
      top.location = xblibrary.path + '/errors/index.html?msg=' + escape(msg) + '&url=' + escape(url) + '&line=' + escape(line);
  }
}

function xbLibrary(path)
{
  if (path.charAt(path.length-1) == '/')
  {
    path = path.substr(0, path.length-1)
  }
  this.path = path;
}

// dynamically loaded scripts
//
// it is an error to reference anything from the dynamically loaded file inside the
// same script block.  This means that a file can not check its dependencies and
// load the files for it's own use.  someone else must do this.  
  
xbLibrary.prototype.loadScript = 
function (scriptName)
{
  document.write('<script language="javascript" src="' + this.path + '/' + scriptName + '"><\/script>');
};

// default xbLibrary

xblibrary = new xbLibrary('/xbProjects-srce/');


