/*
 * $Id: xbMenu.js,v 1.2 2003/09/14 21:22:26 bc Exp $
 *
 */

/* ***** BEGIN LICENSE BLOCK *****
 * The contents of this file are subject to the Mozilla Public License Version 
 * 1.1 (the "License"); you may not use this file except in compliance with 
 * the License. You may obtain a copy of the License at 
 * http://www.mozilla.org/MPL/
 * 
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 * 
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Bob Clary code.
 *
 * The Initial Developer of the Original Code is
 * Bob Clary.
 * Portions created by the Initial Developer are Copyright (C) 2000
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Bob Clary <http://bclary.com/>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 * 
 ***** END LICENSE BLOCK ***** */

/////////////////////////////////////////////////////////////
//
// Implement Menu Widget
// Copyright (c) 2000 by Bob Clary, All Rights Reserved
//
/////////////////////////////////////////////////////////////

_classes.registerClass('xbMenuData', 'xbTreeNode');

function xbMenuData(menuId, label)
{
	_classes.defineClass('xbMenuData', _prototype_func);
	
	this.init(menuId, label);

	function _prototype_func()
	{
		xbMenuData.prototype.init = init;
		function init(menuId, label)
		{
			this.parentMethod('init');
			
			this.nodeName		= 'menu';
			this.id				= menuId;
			this.label			= label;
			this.topMenu		= null;	// top level will have topMenu == null
		}
		
		xbMenuData.prototype.getQualifiedId	= getQualifiedId;
		function getQualifiedId()
		{
			var node  = this.parentNode;
			var sName = this.id;
			
			while (node)
			{
				if (node.id)
					sName = node.id + '_' + sName;
				node  = node.parentNode;
			}
			
			return sName;
		}
		
		xbMenuData.prototype.find = find;
		function find(qName)
		{
			var aQnames;
			var oSymbol = null;
			var i;
			
			if (!qName)
				return null;
				
			aQnames = qName.split('_');
			
			if (aQnames[0] != this.id)
				return null;
				
			aQnames = aQnames.slice(1);
			
			for (i = 0; i < this.childNodes.length; i++)
			{
				oSymbol = _findChildNode(this.childNodes.item(i), aQnames);
				if (oSymbol)
					return oSymbol;
			}
			
			return oSymbol;
		}

		function _findChildNode(menuData, aQnames)
		{
			if (aQnames.length == 0)
				return null;
				
			if (aQnames[0] != menuData.id)
				return null;

			if (aQnames.length == 1)
				return menuData;
				
			var i;
			var oSymbol    = null;
			var aQsubnames = aQnames.slice(1);
			
			for (i = 0; i < menuData.childNodes.length; i++)
			{
				oSymbol = _findChildNode(menuData.childNodes.item(i), aQsubnames);
				if (oSymbol != null)
					break;
			}
			return oSymbol;
		}
		
		xbMenuData.prototype.isTopMenu = isTopMenu;
		function isTopMenu()
		{
			return this.topMenu == this;
		}
		
		xbMenuData.prototype.isRootMenu = isRootMenu;
		function isRootMenu()
		{
			return this == _menuDataRoot;
		}
		
		xbMenuData.prototype.addItem = addItem;
		function addItem(id, label, onclick)
		{
			var item		= new xbMenuData(id, label);
			
			item.nodeName	= 'menuitem';
			item.onclick	= onclick;
			
			this.appendChild(item);
			
			item.topMenu	= this.topMenu  ? this.topMenu  : this;
			
			return item;
		}
		
		xbMenuData.prototype.addMenu = addMenu;
		function addMenu(id, label)
		{
			var menu = new xbMenuData(id, label);
			
			this.appendChild(menu);

			menu.topMenu	= this.topMenu  ? this.topMenu  : menu;

			return menu;
		}
		
		xbMenuData.prototype.toString = toString;
		function toString()
		{
			var s = '<' + this.nodeName + ' id="' + this.id + '">';
			
			for (var i = 0; i < this.childNodes.length; i++)
			{
				s += this.childNodes.item(i).toString();
			}
			s += '</' + this.nodeName + '>';
			
			return s;
		}
		
	}	
}

// _menuDataRoot is the root of the tree that contains all 
// xbMenuData defined for a given page.
_menuDataRoot = new xbMenuData('rootMenuId', 'Root Menu');


_menuCollection = new Object();

_classes.registerClass('xbMenu');

function xbMenu(menuData, menuType)
{
	_classes.defineClass('xbMenu', _prototype_func);
	
	this.init(menuData, menuType);
	
	function _prototype_func()
	{
		xbMenu.prototype.init = init;
		function init(menuData, menuType)
		{
			this.parentMethod('init');
			// note this id scheme allows one menu of each type for a given menuData
			this.id									= menuType + menuData.id;
			_menuCollection[this.id]				= this;			

			this.menuData							= menuData;
			this.debug								= false;
			this.menuType							= menuType;
			
			this.openMenuItems						= new xbArray();
			
			this.menuStyle							= new Object();
			this.menuStyle.fontFamily				= '"ms sans serif" verdana "sans serif"';
			this.menuStyle.fontSize					= '8pt';
			this.menuStyle.color					= 'black';
			this.menuStyle.backgroundColor			= '#d6d6ce';
			this.menuStyle.onEdgeColor				= '#f0f0f0';
			this.menuStyle.offEdgeColor				= '#808080';
			this.menuStyle.textDecoration			= 'none';
			this.menuStyle.activeBackgroundColor	= 'steelblue';
			this.menuStyle.activeColor				= 'white';
			this.menuStyle.borderWidth				= '1'; 
			this.menuStyle.borderStyle				= 'solid';
			this.menuStyle.padding					= '2px 0px 2px 0px';
			this.menuStyle.width					= '126px';

			this.itemStyle							= new Object();
			this.itemStyle.fontFamily				= '"ms sans serif" verdana "sans serif"';
			this.itemStyle.fontSize					= '8pt';
			this.itemStyle.color					= 'black';
			this.itemStyle.backgroundColor			= '#d6d6ce';
			this.itemStyle.onEdgeColor				= '#f0f0f0';
			this.itemStyle.offEdgeColor				= '#808080';
			this.itemStyle.textDecoration			= 'none';
			this.itemStyle.activeBackgroundColor	= 'steelblue';
			this.itemStyle.activeColor				= 'white';
			this.itemStyle.borderWidth				= '1'; 
			this.itemStyle.borderStyle				= 'solid';
			this.itemStyle.padding					= '2px 0px 2px 0px';
			this.itemStyle.width					= '122px';
		}
		
		xbMenu.prototype.toHostElements = toHostElements;
		function toHostElements(menuData)
		{
			var hostElements				= new Object();
			// ie5 does not support createDocumentFragment, so...
			hostElements.subMenus			= new xbArray();
			
			var menuElementId;
			
			var menuElement;
			var menuElementNodeName			= null;
			var menuElementPosition			= null;
			var menuElementVisibility		= null;
			var menuElementDisplay			= null;

			var menuElementBorderState		= 'unselected';
		
			var menuItemNodeName;
			var menuItemPosition			= null;
			var menuItemVisibility			= null;
			var menuItemBorderstate;
			
			var	menuElementFontFamily		= this.menuStyle.fontFamily;
			var	menuElementFontSize			= this.menuStyle.fontSize;
			var	menuElementColor			= this.menuStyle.color;
			var	menuElementBackgroundColor	= this.menuStyle.backgroundColor;
			var	menuElementTextDecoration	= this.menuStyle.textDecoration;
			var	menuElementBorderWidth		= this.menuStyle.borderWidth; 
			var	menuElementBorderStyle		= this.menuStyle.borderStyle;
			var	menuElementPadding			= this.menuStyle.padding;
			var	menuElementWidth			= this.menuStyle.width;

			var	menuItemFontFamily			= this.itemStyle.fontFamily;
			var	menuItemFontSize			= this.itemStyle.fontSize;
			var	menuItemColor				= this.itemStyle.color;
			var	menuItemBackgroundColor		= this.itemStyle.backgroundColor;
			var	menuItemTextDecoration		= this.itemStyle.textDecoration;
			var	menuItemBorderWidth			= this.itemStyle.borderWidth;
			var	menuItemBorderStyle			= this.itemStyle.borderStyle;;
			var menuItemPadding				= this.itemStyle.padding;
			var	menuItemWidth				= this.itemStyle.width;
			
			menuElementId 	= 'menu_'    + this.id + '_' + menuData.getQualifiedId();
			
			switch (this.menuType)
			{
			case 'PullDownAuto':
			
				menuElementNodeName			= 'div';
				
				if (menuData.isTopMenu())
				{
					menuElementWidth		= '';
					menuItemNodeName		= 'span';
					menuItemWidth			= '';
				}
				else
				{
					menuElementPosition 	= 'absolute';
					menuElementVisibility	= 'hidden';
					menuElementBorderState	= 'active';
					menuItemNodeName		= 'div';
				}
				break;

			case 'PullDownManual':
			
				menuElementNodeName			= 'div';
				
				if (menuData.isTopMenu())
				{
					menuElementWidth		= '';
					menuItemNodeName		= 'span';
					menuItemWidth			= '';
				}
				else
				{
					menuElementPosition		= 'absolute';
					menuElementVisibility	= 'hidden';
					menuElementBorderState	= 'active';
					menuItemNodeName		= 'div';
				}
				break;

			case 'NavbarAuto':
			
				menuElementNodeName			= 'div';
				menuItemNodeName			= 'div';
				
				if (!menuData.isTopMenu())
				{
					menuElementPosition		= 'absolute';
					menuElementVisibility	= 'hidden';
					menuElementBorderState	= 'active';
				}
				break;
				
			case 'NavbarList':
			
				menuElementNodeName			= 'ul';
				menuItemNodeName			= 'li';

				if (!menuData.isTopMenu())
				{
					menuElementBorderState	= 'active';
					menuElementDisplay		= 'none';
				}
				break;
				
			default:
				throw(new xbException('Unknown Menu Type', 'xbMenu2.js', 'xbMenu::toHostElements'));
			}

			menuElement = hostElements.menuElement = document.createElement(menuElementNodeName);
			menuElement.id						= menuElementId;
			menuElement.style.fontFamily		= menuElementFontFamily;
			menuElement.style.fontSize			= menuElementFontSize;
			menuElement.style.color				= menuElementColor;
			menuElement.style.backgroundColor	= menuElementBackgroundColor;
			menuElement.style.textDecoration	= menuElementTextDecoration;
			menuElement.style.borderWidth		= menuElementBorderWidth;
			menuElement.style.borderStyle		= menuElementBorderStyle;
			menuElement.style.padding			= menuElementPadding;
			menuElement.style.width				= menuElementWidth;
			
			// always force the menu text to be left aligned with out regard to any
			// alignment of the parent elements...
			menuElement.style.textAlign = 'left';

			if (menuElementPosition != null)
				menuElement.style.position 	= menuElementPosition;
				
			if (menuElementVisibility != null)
				menuElement.style.visibility = menuElementVisibility;

			if (menuElementDisplay != null)
				menuElement.style.display = menuElementDisplay;

			this._setMenuElementBorders(menuElement, menuElementBorderState);
			
			var itemElement;
			var itemMenuData = menuData.firstChild;
						
			while (itemMenuData)
			{
				itemElement = menuElement.appendChild(document.createElement(menuItemNodeName));
				itemElement.id						= 'item_' + this.id + '_' + itemMenuData.getQualifiedId();
				itemElement.style.fontFamily		= menuItemFontFamily;
				itemElement.style.fontSize			= menuItemFontSize;
				itemElement.style.color				= menuItemColor;
				itemElement.style.backgroundColor	= menuItemBackgroundColor;
				itemElement.style.textDecoration	= menuItemTextDecoration;
				itemElement.style.borderWidth		= menuItemBorderWidth;
				itemElement.style.borderStyle		= menuItemBorderStyle;
				itemElement.style.padding			= menuItemPadding;
				itemElement.style.width				= menuItemWidth;
				
				itemElement.style.textAlign = 'left';
				
				this._setMenuElementBorders(itemElement, 'unselected');

				// use spaces to separate since ie won't handle padding or much else on
				// spans

				if (itemMenuData.nodeName == 'menu')
				{
					var label = ' ' + itemMenuData.label;
					
					if (!itemMenuData.parentNode.isTopMenu())
					{
						label += ' ->';
					}
						
					itemElement.appendChild( document.createTextNode( label ) );
					
					var menuHostElements = this.toHostElements(itemMenuData);
					switch (this.menuType)
					{
					case 'PullDownAuto':
					case 'PullDownManual':
					case 'NavbarAuto':
						hostElements.subMenus.push(menuHostElements.menuElement);
						var i;
						for (i = 0; i < menuHostElements.subMenus.length; i++)
							hostElements.subMenus.push(menuHostElements.subMenus.item(i));
						break;
								
					case 'NavbarList':
						itemElement.appendChild(menuHostElements.menuElement);
						var i;
						for (i = 0; i < menuHostElements.subMenus.length; i++)
							menuHostElements.menuElement.appendChild(menuHostElements.subMenus.item(i));
						break;
					}

				}
				else if (itemMenuData.nodeName == 'menuitem')
				{
					var onclick = itemMenuData.onclick;
					if (onclick)
					{
						if (typeof(onclick) == 'string')
						{
							// give the link an id since it will fire mouse events...
							
							var linkElement = itemElement.appendChild( document.createElement('a'));
							linkElement.setAttribute('href', onclick);
							linkElement.appendChild( document.createTextNode( ' ' + itemMenuData.label + ' ' ) );

							linkElement.id						= 'link_' + this.id + '_' + itemMenuData.getQualifiedId();
							linkElement.style.color				= menuItemColor;
							linkElement.style.backgroundColor	= menuItemBackgroundColor;							
							linkElement.style.width				= menuItemWidth;
							linkElement.style.textDecoration	= menuItemTextDecoration;
							
							/*
							var onclickHandler = new Function('evt', 'document.location.href="' + onclick + '"');
							itemElement.appendChild( document.createTextNode( ' ' + itemMenuData.label + ' ' ) );
							AddEventListener(window, itemElement, 'click', onclickHandler, false);
							*/
						}
						else
						{
							itemElement.appendChild( document.createTextNode( ' ' + itemMenuData.label + ' ' ) );
							AddEventListener(window, itemElement, 'click', onclick, false);
						}
					}
					menuElement.appendChild( itemElement );
				}
				itemMenuData = itemMenuData.nextSibling;
			}
			return hostElements;
		}

		xbMenu.prototype.setEventListeners = setEventListeners;
		function setEventListeners()
		{
			switch(this.menuType)
			{
			case 'PullDownAuto':
			case 'NavbarAuto':
				AddEventListener(window, document.body, 'mouseover', _oncommand, false);
				break;
			case 'PullDownManual':
			case 'NavbarList':
				AddEventListener(window, document.body, 'click', _oncommand, false);
				break;
			default:
				throw( new xbException('Unknown menu type', 'xbMenus2.js', 'xbMenu::setEventListeners') );
			}
		}

		// private method
		xbMenu.prototype._setMenuElementBorders = _setMenuElementBorders;
		function _setMenuElementBorders(item, state)
		{
			var itemStyle = item.nodeName == 'menu' ? this.menuStyle : this.itemStyle;
			
			switch (state)
			{
			case 'unselected':
				item.style.borderRightColor		= itemStyle.backgroundColor; 
				item.style.borderBottomColor	= itemStyle.backgroundColor; 
				item.style.borderTopColor		= itemStyle.backgroundColor;
				item.style.borderLeftColor		= itemStyle.backgroundColor;
				break;
					
			case 'active':
				item.style.borderRightColor		= itemStyle.offEdgeColor; 
				item.style.borderBottomColor	= itemStyle.offEdgeColor; 
				item.style.borderTopColor		= itemStyle.onEdgeColor;
				item.style.borderLeftColor		= itemStyle.ondgeColor;
				break;
		
			case 'selected':
				item.style.borderRightColor		= itemStyle.onEdgeColor; 
				item.style.borderBottomColor	= itemStyle.onEdgeColor; 
				item.style.borderTopColor		= itemStyle.offEdgeColor;
				item.style.borderLeftColor		= itemStyle.offEdgeColor;
				break;
			}
		}
		
		//
		// begin dynamic pull down menu handling...
		//
		
		// parse a menuElement's id
		function parseMenuElementId(elementId)
		{
			var idArray = elementId.split('_');
			var idData  = new Object();
			
			if (idArray.length < 3)
			{
				idData.type			= '';
				idData.xbMenuId		= '';
				idData.xbMenuDataId = '';
			}
			else
			{
				idData.type			= idArray[0];
				idData.xbMenuId		= idArray[1];
				var temp = idArray.slice(2);
				idData.xbMenuDataId	= temp.join('_');
			}
			
			return idData;
		}

		function _oncommand(evt)
		{
			var error;
			
			try
			{
				var menuElement;
				
				// handle mozilla's need to fire for #text elements...
				// actually this is standards compliant. standard says fire 
				// events for nodes!
				if (evt.target.nodeType == 1)
					menuElement = evt.target;
				else
					menuElement = evt.target.parentNode;
					
				if (!menuElement)
				{
					_closeall();
					return;
				}
					
				// ignore mouseovers for hidden elements
				if (menuElement.style.visibility == 'hidden')
					return;
		
				var idData = parseMenuElementId(menuElement.id);
							
				// because A fires a mouseover, jump to it's container					
				if (idData.type == 'link')
					menuElement = menuElement.parentNode;
					
				if (!menuElement)
				{
					_closeall();
					return;
				}
						
				// map the host element into the xbMenuData element
				// what about if the found menuData doesn't belong to this menu?
				var menuData = _menuDataRoot.find(idData.xbMenuDataId);
				if (!menuData)
				{
					_closeall();
					return;
				}

				var menu  = _menuCollection[idData.xbMenuId];
				
			
				if (menu.debug)
					writeLogWindow(evt.type + ': ' + evt.target.nodeName + ':' + evt.target.id);

				if (menuData == menu.openMenuItems.top() && menu.menuType == 'NavbarList')
				{	// we have clicked on an open NavbarList menu
					// if it is the 'last' opened menu, then close it, otherwise
					// let open handle it
					_close(menu, menuData);
				}
				else
					_open(menu, menuData, menuElement);
			}
			catch(error)
			{
				var exception = new xbException('', 'xbMenus2.js', 'xbMenu::_oncommand', error);
				alert(exception.toString());
				throw(exception);
			}
		}
		
		// private method
		function _open(menu, menuData, menuElement)
		{
			if (menu.debug)
				writeLogWindow('_open: ' + menuData.nodeName + ':' + menuData.id);

			// make sure all menus from other menu documents are closed....
			var otherMenuName;
			var otherMenu
			var openMenuData;
			
			for (otherMenuName in _menuCollection)
			{
				otherMenu = _menuCollection[otherMenuName];
				
				if (otherMenu != menu)
				{
					var openMenuItems	= otherMenu.openMenuItems;
					var openMenuData	= openMenuItems.top();
			
					while (openMenuData)
					{
						_close(otherMenu,  openMenuData);
						openMenuData = openMenuItems.top();
					}
				}
			}

			// close menus in our menu document until we find the one 
			// that contains menuData element... 
			// if it is contained that is.

			openMenuData = menu.openMenuItems.top();
			while (openMenuData)
			{
				if (Contains(openMenuData, menuData)) 
					break;
					
				_close(menu, openMenuData);
				openMenuData = menu.openMenuItems.top();
			}

			switch(menuData.nodeName)
			{
			case 'menuitem':
				menu._setMenuElementBorders(menuElement, 'active');
				menuElement.style.cursor = (document.all) ? 'hand' : 'pointer';
				
				var Style = (menuData.parentNode.isTopMenu() ? menu.menuStyle : menu.itemStyle)
				menuElement.style.color				= Style.activeColor; 
				menuElement.style.backgroundColor	= Style.activeBackgroundColor;
					
				// handle case where child nodes like A need to be handled.
				var i;
				for (i = 0; i < menuElement.childNodes.length; i++)
				{
					var child = menuElement.childNodes.item(i);
					if (child.style)
					{
						// mozilla will not set the forground color menuData way for A links
						child.style.color			= Style.activeColor; 
						child.style.backgroundColor	= Style.activeBackgroundColor;
					}
				}
				break;
								
			case 'menu':
				// don't do anything to the menubar.
				if (menuData.isTopMenu())
					return;

				// don't open a menu if it is already open
				if (openMenuData != menuData) 
				{
					var subMenu		= document.getElementById('menu_' + menu.id + '_' + menuData.getQualifiedId());
					var parentMenu	= document.getElementById('menu_' + menu.id + '_' + menuData.parentNode.getQualifiedId());	

					// should i throw an exception here?
					if (subMenu == null)
						return;		
			
					menu._setMenuElementBorders(menuElement, 'active');
					menu._setMenuElementBorders(subMenu,     'active');
				
					// note menu elements won't have embedded A elements and don't
					// need their children processed in the same fashion as menuitems.
					menuElement.style.color				= menu.menuStyle.activeColor; 
					menuElement.style.backgroundColor	= menu.menuStyle.activeBackgroundColor;
					
					var menuElementBoundary			= getBoundary(menuElement);
					var parentMenuElementBoundary	= getBoundary(parentMenu);
					var bodyBoundary				= getBoundary(document.body);

	 				if (menu.debug)
	 				{
						writeLogWindow('_open: ' + 'menuElementBoundary: ' + menuElementBoundary.left + ', ' + menuElementBoundary.top + ', ' + menuElementBoundary.right + ', ' + menuElementBoundary.bottom);
						writeLogWindow('_open: ' + 'parentMenuElementBoundary: ' + parentMenuElementBoundary.left + ', ' + parentMenuElementBoundary.top + ', ' + parentMenuElementBoundary.right + ', ' + parentMenuElementBoundary.bottom);
					}

					
					switch (menu.menuType)
					{
					case 'PullDownAuto':
					case 'PullDownManual':
						if (menuData.parentNode == menuData.topMenu)
						{
							if (menuElementBoundary.left + subMenu.offsetWidth < bodyBoundary.right)
								setPosition(subMenu, menuElementBoundary.left, menuElementBoundary.bottom);
							else
								setPosition(subMenu, menuElementBoundary.right - subMenu.offsetWidth, menuElementBoundary.bottom);
						}
						else 
						{
							if (menuElementBoundary.right + subMenu.offsetWidth < bodyBoundary.right)
								setPosition(subMenu, menuElementBoundary.right, menuElementBoundary.top);
							else 
								setPosition(subMenu, menuElementBoundary.left - subMenu.offsetWidth, menuElementBoundary.top);
						}
							
						subMenu.style.visibility	= 'visible';
						subMenu.style.zIndex		= 1;
						break;
					
					case 'NavbarAuto':
						if (menuElementBoundary.right + subMenu.offsetWidth < bodyBoundary.right)
							setPosition(subMenu, menuElementBoundary.right, menuElementBoundary.top);
						else
							setPosition(subMenu, menuElementBoundary.left - subMenu.offsetWidth, menuElementBoundary.top);

						subMenu.style.visibility	= 'visible';
						subMenu.style.zIndex		= 1;
						break;
					
					case 'NavbarList':
						subMenu.style.display		= 'block';
						break;
						
					default:
						throw( new xbException('Unknown menu type', 'xbMenus2.js', 'xbMenu::_open') );
					}
				}
				break;
								
			default:
				throw(new xbException('Invalid menu element', 'xbMenus2.js', 'xbMenu::_open') );
				break;
			}
			
			menu.openMenuItems.push(menuData);
		}

		// private method
		function _close(menu, menuData)
		{
			if (menu.debug)
				writeLogWindow('_close ' + menuData.nodeName + ':' + menuData.id);
			
			var menuElement;
			var openedLast = menu.openMenuItems.pop();
			
			if (menuData != openedLast)
				throw( new xbException('Closing wrong menu', 'xbMenus2.js', 'xbMenu::_close') );

			switch(menuData.nodeName)
			{
			case 'menu':
				menuElement = document.getElementById('menu_' + menu.id + '_' + menuData.getQualifiedId());
				if (menuElement == null)
					throw( new xbException('menu not found', 'xbMenus2.js', 'xbMenu::_close') );

				menu._setMenuElementBorders(menuElement, 'unselected');			

				switch(menu.menuType)
				{
				case 'PullDownAuto':
				case 'PullDownManual':
					menuElement.style.visibility = 'hidden';
					menuElement.style.zIndex		= 0;
					break;
				case 'NavbarAuto':
					menuElement.style.visibility = 'hidden';
					menuElement.style.zIndex		= 0;
					break;
				case 'NavbarList':
					menuElement.style.display	  = 'none';
					break;
				default:
					throw( new xbException('Unknown menu type', 'xbMenus2.js', 'xbMenu::_close') );
				}
								
				// only switch color and background color for submenus...
				if (!menuData.isTopMenu())
				{
					menuElement.style.color				= menu.menuStyle.color; 
					menuElement.style.backgroundColor	= menu.menuStyle.backgroundColor;
				}
				// deliberate fall through
				// each submenu consists of the activated menuitem on the parent menu plus
				// the open submenu 'window'.  falling through allows us to deal with both
				// easily.
				
			case 'menuitem':
				menuElement = document.getElementById('item_' + menu.id + '_' + menuData.getQualifiedId());
				if (menuElement == null)
					throw( new xbException('menu item not found', 'xbMenus2.js', 'xbMenu::_close') );
					
				menu._setMenuElementBorders(menuElement, 'unselected');
				menuElement.style.cursor = 'auto';
				
				var Style = (menuData.parentNode.isTopMenu() ? menu.menuStyle : menu.itemStyle)
				menuElement.style.color				= Style.color; 
				menuElement.style.backgroundColor	= Style.backgroundColor;
					
				// handle case where child nodes like A need to be handled.
				var i;
				for (i = 0; i < menuElement.childNodes.length; i++)
				{
					var child = menuElement.childNodes.item(i);
					if (child.style)
					{
						// mozilla will not set the forground color menuData way for A links
						child.style.color			= menu.itemStyle.color; 
						child.style.backgroundColor	= menu.itemStyle.backgroundColor;
					}
				}
				break;

			default:
				throw(new xbException('Invalid menu element', 'xbMenus2.js', 'xbMenu::_close') );
			}
		}
		
		function _closeall()
		{
			var error;
			
			try
			{
				var menuName;
				var menu;
				var openMenuData;
				var openMenuItems
			
				for (menuName in _menuCollection)
				{
					menu			= _menuCollection[menuName];
					openMenuItems	= menu.openMenuItems;
					openMenuData	= openMenuItems.top();
			
					while (openMenuData)
					{
						_close(menu,  openMenuData);
						openMenuData = openMenuItems.top();
					}
				}
			}
			catch(error)
			{
				var exception = new xbException('', 'xbMenus2.js', 'xbMenu::_closeall', error);
				alert(exception.toString());
				throw(exception);
			}
		}
	}
}

