/*
 * $Id: xbObjects-1.0.js,v 1.2 2003/09/14 21:22:26 bc Exp $
 *
 */

/* ***** BEGIN LICENSE BLOCK *****
 * The contents of this file are subject to the Mozilla Public License Version 
 * 1.1 (the "License"); you may not use this file except in compliance with 
 * the License. You may obtain a copy of the License at 
 * http://www.mozilla.org/MPL/
 * 
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 * 
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Bob Clary code.
 *
 * The Initial Developer of the Original Code is
 * Bob Clary.
 * Portions created by the Initial Developer are Copyright (C) 2000
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Bob Clary <http://bclary.com/>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 * 
 ***** END LICENSE BLOCK ***** */

function _Classes()
{
  if (typeof(_classes) != 'undefined')
    throw('Only one instance of _Classes() can be created');
    
  function registerClass(className, parentClassName)
  {
    if (!className)
      throw(new xbException('registerClass: className not given', 'xbObjects.js', '_Classes::registerClass'));
      
    if (className in _classes)
      return;
      
    if (className != 'xbObject' && !parentClassName)
      parentClassName = 'xbObject';
      
    if (!parentClassName)
      parentClassName = null;
    else if ( !(parentClassName in _classes))
      throw(new xbException('registerClass: parentClassName ' + parentClassName + ' not defined', 'xbObjects.js', '_Classes::registerClass'));

    var objClass;
    objClass        = _classes[className] = new Object();
    // evaluating and caching the prototype object in registerClass
    // works so long as we are dealing with 'normal' source files
    // where functions are created in the global context and then 
    // statements executed. when evaling code blocks as in xbCOM,
    // this no longer works and we need to defer the prototype caching
    // to the defineClass method
    objClass.prototypeObject = null;
    objClass.parentClass  = parentClassName;
  }
  _Classes.prototype.registerClass = registerClass;

  function defineClass(className, prototype_func)
  {
    var p;

    if (!className)
      throw( new xbException('defineClass: className not given', 'xbObjects.js', '_Classes::defineClass'));
      
    if (!(className in _classes))
      throw( new xbException('defineClass: className ' + className + ' not registered', 'xbObjects.js', '_Classes::defineClass'));
    
    if ('prototype_called' in _classes[className])
      return;
      
    var classRef    = _classes[className];
    if (!classRef.prototypeObject)
      classRef.prototypeObject  = eval( className + '.prototype' );
    var childPrototype  = classRef.prototypeObject;
    var parentClassName = classRef.parentClass;
      
    if (parentClassName)
    {
      if ( !(parentClassName in _classes))
        throw( new xbException('defineClass: parentClassName ' + parentClassName + ' not registered', 'xbObjects.js', '_Classes::defineClass'));

      var parentClassRef = _classes[parentClassName];
      
      if ( !('prototype_called' in parentClassRef) )
      {
        // force parent's prototype to be called by creating a dummy instance
        // note constructor must handle 'default' constructor case
        var dummy;
        eval('dummy = new ' + parentClassName + '();');
      }
        
      var parentPrototype = parentClassRef.prototypeObject;
      //var childSuperClass = classRef.superClass;
    
      for (p in parentPrototype)
      {
        if (p != 'isa' && p != 'classRef' && p != 'parentMethod')
          childPrototype[p] = parentPrototype[p];
      }
    }

    prototype_func();
    
    childPrototype['isa']          = className;
    childPrototype['classRef']        = classRef;
    childPrototype['parentMethod']      = xbObject.prototype.parentMethod;
    
    _classes[className].prototype_called  = true;
  }
  _Classes.prototype.defineClass = defineClass;

}

// create global instance
var _classes = new _Classes();

    
// register root class xbObject
_classes.registerClass('xbObject');

function xbObject()
{
  _classes.defineClass('xbObject', _prototype_func);

  this.init();
  
  function _prototype_func()
  {
    // isa is set by defineClass() to the className
    // Note that this can change dynamically as the class is cast
    // into it's ancestors...
    xbObject.prototype.isa        = null;  
    
    // classref is set by defineClass() to point to the 
    // _classes entry for this class. This allows access 
    // the original _class's entry no matter how it has 
    // been recast. 
    // *** This will never change!!!! ***
    xbObject.prototype.classRef      = null;
    
    function init() { }
    xbObject.prototype.init        = init;
    
    function destroy() {}
    xbObject.prototype.destroy      = destroy;

    function parentMethod(method, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9)
    {
      var className  = this.isa;
      var parentClass  = _classes[className].parentClass;
      var tempMethod  = _classes[parentClass].prototypeObject[method];
      
      // find who implemented this method
      while (parentClass != 'xbObject' && tempMethod == this[method])
      {
        parentClass = _classes[parentClass].parentClass;
        tempMethod  = _classes[parentClass].prototypeObject[method];
      }
        
      this.tempMethod  = tempMethod;
      this.isa    = parentClass;
      var retVal    = this.tempMethod(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
      this.isa    = className;
      
      return retVal;
    }
    xbObject.prototype.parentMethod    = parentMethod;
  }
}

_classes.registerClass('xbException');

function xbException(errorMessage, errorFile, errorFunction, exception)
{
  _classes.defineClass('xbException', _prototype_func);
  
  this.init(errorMessage, errorFile, errorFunction, exception);
  
  function _prototype_func()
  {
    function init(errorMessage, errorFile, errorFunction, exception)
    {
      // turn off error handling inside xbExceptions
      var oldonerror = null;
      if (typeof(window.onerror) == 'function')
        oldonerror = window.onerror;
      window.onerror = null;

      if (typeof(exception) == 'object' && typeof(exception.isa) != 'undefined' && exception.isa == 'xbException')
      {
        this.errorMessage  = exception.errorMessage;
        this.errorFile = exception.errorFile;
        this.errorFunction = exception.errorFunction;
        this.nativeMessage  = exception.nativeMessage;
        this.nativeException = exception.nativeException;
      }
      else
      {
        this.errorMessage  = errorMessage;
        this.errorFile = errorFile;
        this.errorFunction = errorFunction;
        this.nativeMessage  = '';

        if (typeof(exception) == 'object')
        {
          var p;
              
          /*
          This causes exceptions in some cases related to
          XPCWrappedNative_NoHelper in Gecko 0.9.5+
          related to permission denied to access filename,
          lineNumber, columnNumber. Revert to the public toString()
          interface.

          for (p in exception)
            if (typeof(exception[p]) == 'string' || typeof(exception[p]) == 'number')
              this.nativeMessage += p + ' = ' + exception[p] + ' ';
          */
          this.nativeMessage = exception + '';
              
          this.nativeException = exception;
        }
      }
      // turn error handlng back on
      window.onerror = oldonerror;
    }
    xbException.prototype.init = init;
    
    function toString()
    {
      // turn off error handling inside xbExceptions
      var oldonerror = null;
      if (typeof(window.onerror) == 'function')
        oldonerror = window.onerror;
      window.onerror = null;

      var s = 'xbException(' + this.errorFile + ' : ' + this.errorFunction + ') ' +
              this.errorMessage + ' / ' + this.nativeMessage;
      // turn error handlng back on
      window.onerror = oldonerror;
      return s;
    }
    xbException.prototype.toString = toString;
  }
}
// eof: xbObjects.js
//</SCRIPT>
