/*
 * $Id: xbQueryString.js,v 1.7 2003/09/14 21:22:26 bc Exp $
 *
 */

// Handle location.search parsing

/* ***** BEGIN LICENSE BLOCK *****
 * The contents of this file are subject to the Mozilla Public License Version 
 * 1.1 (the "License"); you may not use this file except in compliance with 
 * the License. You may obtain a copy of the License at 
 * http://www.mozilla.org/MPL/
 * 
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 * 
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Bob Clary code.
 *
 * The Initial Developer of the Original Code is
 * Bob Clary.
 * Portions created by the Initial Developer are Copyright (C) 2000
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Bob Clary <http://bclary.com/>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 * 
 ***** END LICENSE BLOCK ***** */

_classes.registerClass('xbQueryString');

function xbQueryString()
{
  _classes.defineClass('xbQueryString', _prototype_func);
  
  this.init();
  
  function _prototype_func()
  {
    xbQueryString.prototype.value = null;
    
    function init()
    {
      var q;
      var index;
      var name;
      var value;
      var temp;
      var i;
      
      this.parentMethod('init');
      this.length = 0;
      
      q = document.location.search;
      this.value = new Array();

      if (q)
      {
        q = q.substring(1); // strip leading ?

        var pairs = q.split('&');
        this.length = pairs.length;
        
        for (i = 0; i < pairs.length; ++i)
        {
          index      = pairs[i].indexOf('=');
          name       = pairs[i].substring(0, index);
          value      = unescape(pairs[i].substring(index + 1));
          
          switch(typeof(this.value[name]))
          {
          case 'undefined':
            this.value[name] = value;
            break;
          
          case 'object':
            this.value[name][this.value[name].length] = value;
            break;
          
          case 'string':
            temp = this.value[name];
            this.value[name] = new Array();
            this.value[name][0] = temp;
            this.value[name][1] = value;
            break;
          }
        }
      }
    }
    xbQueryString.prototype.init = init;

    function reset()
    {
      this.value = new Array();
    }
    xbQueryString.prototype.reset = reset;
    
    function initForm(form)
    {
      var i;
      var j;
      var value;
      var elm;
      var opt;
      
      for (i = 0; i < form.elements.length; i++)
      {
        elm = form.elements[i];
        
        if (typeof(this.value[elm.name]) == 'undefined')
        {
          switch(elm.type)
          {
          case 'checkbox':
          case 'radio':
            elm.checked = false;
            break;
            
          case 'select-one':
          case 'select-multiple':
            
            for (j = 0; j < elm.options.length; j++)
            {
              // HACK
              // mozilla has a bug where HTMLSelectElements that
              // are display:none don't have all of their properties
              // this try catch will catch the case where the selected
              // property is not defined.
              // don't use try catch since NN4 will croak
              var olderror = window.onerror;
              window.onerror = null;
              elm.options[j].selected = false;
              window.onerror = olderror
            }
            break;
                  
          case 'hidden':
          case 'text':
          case 'textarea':
            elm.value = '';
            break;
            
          case 'button':
          case 'file':
          case 'image':
          case 'password':
          case 'reset':
          case 'submit':
          default:
            break;
          }
        }
        else
        {
          switch(elm.type)
          {
          case 'checkbox':
          case 'radio':
            value = this.value[elm.name] + ',';  // force array to be joined
            if (value.indexOf(elm.value + ',') != -1)
              elm.checked = true;
            break;
            
          case 'select-one':
          case 'select-multiple':
            value = this.value[elm.name] + ',';  // force array to be joined
            
            for (j = 0; j < elm.options.length; j++)
            {
              if (value.indexOf(elm.options[j].value + ',') != -1)
                elm.options[j].selected = true;
            }
            break;
                  
          case 'hidden':
          case 'text':
          case 'textarea':
            elm.value = this.value[elm.name];
            break;
            
          case 'button':
          case 'file':
          case 'image':
          case 'password':
          case 'reset':
          case 'submit':
          default:
            break;
            
          }
        }
      }
    }    
    xbQueryString.prototype.initForm = initForm;

    function loadForm(form)
    {
      var i;
      var elm;
      var temp;
      
      this.reset();
      
      for (i = 0; i < form.elements.length; i++)
      {
        elm = form.elements[i];
        
        switch(elm.type)
        {
        case 'text':
        case 'textarea':
        case 'select-one':
          this.value[elm.name] = elm.value;
          break;
            
        case 'select-multiple':
          if (typeof(this.value[elm.name]) != 'object')
            this.value[elm.name] = new Array();
                
          if (elm.selected)
            this.value[elm.name][this.value[elm.name].length] = elm.value;
          break;

        case 'checkbox':
          if (typeof(this.value[elm.name]) != 'object')
            this.value[elm.name] = new Array();
                
          if (elm.checked)
            this.value[elm.name][this.value[elm.name].length] = elm.value;
          break;

        case 'radio':
          if (elm.checked)
            this.value[elm.name] = elm.value;
          break;
        }
      }
    }    
    xbQueryString.prototype.loadForm = loadForm;
  }
}


function selectall(form)
{
  for (var i = 0; i < form.elements.length; i++)
    if (typeof(form.elements[i].checked) != 'undefined')
      form.elements[i].checked = true;
}
