/*
 * $Id: xbTestFrame.js,v 1.9 2003/09/14 21:22:27 bc Exp $
 *
 */

// Javascript Test Framework

/* ***** BEGIN LICENSE BLOCK *****
 * The contents of this file are subject to the Mozilla Public License Version 
 * 1.1 (the "License"); you may not use this file except in compliance with 
 * the License. You may obtain a copy of the License at 
 * http://www.mozilla.org/MPL/
 * 
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 * 
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Bob Clary code.
 *
 * The Initial Developer of the Original Code is
 * Bob Clary.
 * Portions created by the Initial Developer are Copyright (C) 2000
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Bob Clary <http://bclary.com/>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 * 
 ***** END LICENSE BLOCK ***** */

/*

This test framework is built upon a symbol table constructed from
the xbTreeNode object.  This framework does not use DOM 
features and therefore can be executed on any platform supporting the
required version of Javascript.

  xbTestData nodes are attached to the TestFrames of the SymTable
  and represent the possible tests to be performed on the xbTestFrame.
  
  Types of Test:
  
  'EQ' tests test whether eval(actualExpr) == eval(expectedExpr)
  'EX' tests test whether a certain EXCEPTION (expectedExpr) is thrown
       when eval(actualExpr) is executed.
*/

_classes.registerClass('xbTestData');

function xbTestData(testType, preCondition, actualExpr, expectedExpr, comment, number)
{
  _classes.defineClass('xbTestData', _prototype_func);
  
  this.init(testType, preCondition, actualExpr, expectedExpr, comment, number);
  
  function _prototype_func()
  {
    xbTestData.prototype.preCondition    = '';
    xbTestData.prototype.testType        = 'EQ';
    xbTestData.prototype.actualExpr      = ''; 
    xbTestData.prototype.expectedExpr    = '';
    xbTestData.prototype.comment         = ''
    xbTestData.prototype.number          = ''
    xbTestData.prototype.actualValue     = '&nbsp;';
    xbTestData.prototype.expectedValue   = '&nbsp;';
    xbTestData.prototype.errorMsg        = 'not tested';
    xbTestData.prototype.tested          = false;
    xbTestData.prototype.testPassed      = false;

    xbTestData.prototype.init = init;
    function init(testType, preCondition, actualExpr, expectedExpr, comment, number)
    {
      this.parentMethod('init');
      
      if (testType != 'EQ' && testType != 'EX')
        throw( new xbException('invalid test type', 'TestFrame.js', 'xbTestData'));
        
      if (!comment)
        comment = '';
        
      if (preCondition)
        this.preCondition    = preCondition;
      if (testType != 'EQ')
        this.testType        = testType;
      if (actualExpr)
        this.actualExpr      = actualExpr;
      if (expectedExpr)
        this.expectedExpr    = expectedExpr;
      if (comment)
        this.comment         = comment;
      if (number)
        this.number          = number;
      // this.actualValue     = '&nbsp;';
      // this.expectedValue   = '&nbsp;';
      // this.errorMsg        = 'not tested';
      // this.tested       = false;
      // this.testPassed      = false;
    }
    
    xbTestData.prototype.destroy = destroy;
    function destroy()
    {
    /*
      this.preCondition    = null;
      this.testType        = null;
      this.actualExpr      = null;
      this.expectedExpr    = null;
      this.comment     = null;
      this.actualValue     = null;
      this.expectedValue   = null;
      this.errorMsg        = null;
      this.tested       = null;
      this.testPassed      = null;
      */
      delete this.preCondition;
      delete this.testType;
      delete this.actualExpr;
      delete this.expectedExpr;
      delete this.comment;
      delete this.actualValue;
      delete this.expectedValue;
      delete this.errorMsg;
      delete this.tested;
      delete this.testPassed;

      this.parentMethod('destroy');
    }
    
    xbTestData.prototype.clone = clone;
    function clone()
    {
      var testData = new xbTestData(this.testType, this.preCondition, this.actualExpr, this.expectedExpr, this.comment, this.number);
      
      testData.actualValue  = this.actualValue;
      testData.expectedValue  = this.expectedValue;
      testData.errorMsg    = this.errorMsg;
      testData.tested      = this.tested;
      testData.testPassed    = this.testPassed;
      
      return testData;
    }
    // testEq performs a test of the form eval(expression) == eval(expected)
    xbTestData.prototype.testEq       = testEq;
    function testEq(testFrame, topNode)
    {
      var eError;

      try 
      {
        if (!topNode) topNode = null;  

        var sName = testFrame.getQualifiedName(topNode); 
        var sParentName = testFrame.parentNode == null ? '' : testFrame.parentNode.getQualifiedName(topNode);
        var sExprSub;
        var sExpectedSub;
        var preCondition;
        var actualValue;
        var expectedValue;
        
        try
        {
          var sPreCondition = testFrame.replaceParms(this.preCondition, topNode);
          preCondition = eval(sPreCondition);

          if (typeof(preCondition) != 'boolean')
            throw( new xbException('preCondition not boolean', 'xbTestFrame.js', 'xbTestData::testEq', eError));
        }
        catch(eError)
        {
          ++testFrame.failed;
          throw( new xbException('Failure evaluating preCondition', 'xbTestFrame.js', 'xbTestData::testEq', eError));
        }
        
        if (!preCondition)
        {
          ++testFrame.skipped;
          this.errorMsg = 'Pre Condition not met';
        }
        else
        {
          sExprSub      = testFrame.replaceParms(this.actualExpr, topNode);
          sExpectedSub  = testFrame.replaceParms(this.expectedExpr, topNode);
        
          this.tested      = true;
          try
          {
            actualValue      = eval(sExprSub);
          }
          catch(eError)
          {
          }
          try
          {
            expectedValue   = eval(sExpectedSub);
          }
          catch(eError)
          {
          }
        
          if (typeof(sExpectedSub) == 'undefined' || typeof(actualValue) == 'undefined')
            this.testPassed = false;
          else
            this.testPassed    = (expectedValue === actualValue);
          
          this.errorMsg = '';
          
          if (this.testPassed)
            ++testFrame.passed;
          else
            ++testFrame.failed;
        }
      }
      catch (eError)
      {
        var exception = new xbException('Caught Exception', '', '', eError); 
        this.errorMsg = exception.toString();
            
        ++testFrame.failed;
        // reset value in case test modified it
        // note that this can fail if the implementation croaks during the 
        // assignment. So, wrap in a try catch
        var eDummy;
        try
        {
          if (eval(sName + ' != testFrame.nameEval'))
            eval(sName + ' = testFrame.nameEval;');
        }
        catch (eDummy)
        {
          ;
        }
      }
      finally
      {
        // convert object references to their string values 
        // to discard the objects so they can be gc'd
        this.actualValue = actualValue
        this.expectedValue = expectedValue
      }
    }
    
    // testEx performs a test where it a certain Exception is expected to be 
    // thrown when evaluating the expression.

    xbTestData.prototype.testEx       = testEx;
    function testEx(testFrame, topNode)
    {
      var eError;

      try 
      {
        if (!topNode) topNode = null;  
      
        var sName   = testFrame.getQualifiedName(topNode);
        var sParentName = testFrame.parentNode == null ? '' : testFrame.parentNode.getQualifiedName(topNode);  
        var sExprSub;
        var dummy;
        var preCondition;
        var actualValue;
        var expectedValue;

        try
        {
          var sPreCondition = testFrame.replaceParms(this.preCondition, topNode);
          preCondition = eval(sPreCondition);
          if (typeof(preCondition) != 'boolean')
            throw( new xbException('preCondition not boolean', 'xbTestFrame.js', 'xbTestData::testEx', eError));
        }
        catch(eError)
        {
          ++testFrame.failed;
          throw( new xbException('Failure evaluating preCondition', 'xbTestFrame.js', 'xbTestData::testEx', eError));
        }
        
        if (!preCondition)
        {
          ++testFrame.skipped;
          this.errorMsg = 'Pre Condition not met';
        }
        else
        {
          sExprSub      = testFrame.replaceParms(this.actualExpr, topNode);
          this.tested      = true;
          dummy        = eval(sExprSub);
          this.testPassed    = false;
          this.errorMsg = 'EXCEPTION not thrown';
          ++testFrame.failed;
          // reset value in case test modified it
          // note that this can fail if the implementation croaks during the 
          // assignment. So, wrap in a try catch
          var eDummy;
          try
          {
            if (eval(sName + ' != testFrame.nameEval'))
              eval(sName + ' = testFrame.nameEval;');
          }
          catch (eDummy)
          {
            this.errorMsg = '';
          }
        }
      }
      catch (eError)
      {
        expectedValue = eval(this.expectedExpr);
        
        if ('code' in eError)
        {
          actualValue = eError.code;

          this.errorMsg = eError.name + ': ' + 'Result=' + eError.result + ' ' +  eError.message;
          
          if (actualValue == expectedValue)
            this.testPassed = true;
          else
            this.testPassed = false;
        }
        else if ('description' in eError)
        {
          actualValue = undefined;
          this.errorMsg = '';
          
          if (eError.number)
            this.errorMsg = '(' + eError.number + ') ';
        
          this.errorMsg += eError.description;
        }
        else
        {
          var exception = new xbException('Caught Exception', '', '', eError); 
          
          this.errorMsg = exception.toString();
        }

        if (this.testPassed)
          ++testFrame.passed;
        else
          ++testFrame.failed;
      }
      finally
      {
        // convert object references to their string values 
        // to discard the objects so they can be gc'd
        this.actualValue = actualValue;
        this.expectedValue = expectedValue;
      }
    }
    
    xbTestData.prototype.test         = test;
    function test(testFrame, topNode)
    {

      if (!topNode) topNode = null;  
    
      switch (this.testType)
      {
      case 'EQ':
        this.testEq(testFrame, topNode);
        break;
      case 'EX':
        this.testEx(testFrame, topNode);
        break;
      default:
        throw( new xbException('invalid test type', 'TestFrame.js', 'test'));
        break;
      }
    }
  }
}  
    
/*
  a xbTestFrame is a xbTreeNode that represents the qualified name of
  an object and manages the tests and test results for that object.
*/

_classes.registerClass('xbTestFrame', 'xbTreeNode');

    // The actualExpr and expectedExpr expressions for a new test can refer
    // to the new test's xbTestFrame and it's parent through the use of the
    // pseudo variables $this and $parent.  $this will be replaced in the
    // expression by the fully qualified name of the test's xbTestFrame while
    // $parent will be replaced by the fully qualified name of the parent of
    // the test's xbTestFrame.
    //
    // eq. if you are adding a test to the 'a.b.c' xbTestFrame, then $this ~ 'a.b.c'
    // while $parent ~ 'a.b'

function xbTestFrame(nodeName, feature, version, docRef, delayedEval)
{
  _classes.defineClass('xbTestFrame', _prototype_func);
    
  this.init(nodeName, feature, version, docRef, delayedEval);

  function _prototype_func()
  {
    xbTestFrame.prototype.init = init;
    function init(nodeName, feature, version, docRef, delayedEval)
    {
      this.parentMethod('init');
      
      if (!nodeName) nodeName = '';
      if (!feature)  feature = '';
      if (!version)  version = '';
      if (!docRef)   docRef = '';
      if (!delayedEval) delayedEval = false;
      
      this.nodeName    = nodeName;
      this.feature     = feature;
      this.version     = version;
      this.docRef      = docRef;
      this.testArray   = new Array();
      this.nameEval    = '';
      this.nameExists  = false;
      this.testInstances = null; // assign an array when needed
      this.delayedEval = delayedEval;
      this.instanceOf  = null;
      this.passed      = 0;
      this.failed      = 0;
      this.skipped     = 0;
      this.sorted      = false;
    }
    
    xbTestFrame.prototype.destroy = destroy;
    function destroy()
    {
      var i;
      
      for (i = 0; i < this.testArray.length; i++)
      {
        this.testArray[i].destroy();
        this.testArray[i] = null;
      }

      if (this.testInstances)
        for (i = 0; i < this.testInstances.length; i++)
          this.testInstances[i] = null;
        
      this.nodeName = null;
      
      this.parentMethod('destroy');
    }

    xbTestFrame.prototype.clone = clone;
    function clone()
    {
      var i;
      var testFrame = new xbTestFrame(this.nodeName, this.feature, this.version, this.docRef, this.delayedEval);
      
      for (i = 0; i < this.testArray.length; i++)
        testFrame.testArray[i] = this.testArray[i].clone();
        
      testFrame.nameEval    = this.nameEval;
      testFrame.nameExists  = this.nameExists;
      
      if (this.testInstances)
      {
        testFrame.testInstances = new Array();
        
        for (i = 0; i < this.testInstances.length; i++)
          testFrame.testInstances[i] = this.testInstances[i];
      }
      
      testFrame.instanceOf  = this.instanceOf;
      testFrame.passed    = 0;
      testFrame.failed    = 0;
      testFrame.skipped    = 0;
      testFrame.sorted    = false;
      
      return testFrame;
    }
    

    xbTestFrame.prototype.getQualifiedName  = getQualifiedName;
    function getQualifiedName(topNode)
    {
      // get qualified name of this node relative
      // to the specified topNode.
      // topNode == null represent the root's parent
      // assumes 'this' is a descendant of topNode
      
      if (!topNode) topNode = null;  
      
      var node  = this;
      var name  = '';
      
      if (this == topNode)
        return name;
      
      while (node && node != topNode)
      {
        if (node.nodeName != '')
        {
          if (name)
            name = node.nodeName + '.' + name;
          else
            name = node.nodeName;
        }
          
        node  = node.parentNode;
      }
      
      if (node == null && topNode != null)
        throw new xbException('node and topNode not on same tree', 'xbTestFrame.js', 'xbTestFrame::getQualifiedName');
      
      return name;
    }

    // replaceParms is used to replace instances of the pseudo-variables
    // $this and $parent, $grandparent in expressions to be evaluated.

    xbTestFrame.prototype.replaceParms = replaceParms;
    function replaceParms(expr, topNode)
    {
      var result;
      
      if (!topNode) topNode = null;
      
      var thisName = this.getQualifiedName(topNode);
      var parentName = '';
      var grandparentName = '';
      var parentNode = this.parentNode;
      
      if (parentNode && parentNode != topNode)
      {
        parentName = this.parentNode.getQualifiedName(topNode);
        var grandparentNode = parentNode.parentNode;
        if (grandparentNode && grandparentNode != topNode)
          grandparentName = this.parentNode.parentNode.getQualifiedName(topNode);
      }
      
      result = expr.replace(/\$this/g, thisName);
      result = result.replace(/\$parent/g, parentName);
      result = result.replace(/\$grandparent/g, grandparentName);
      
      return result;
    }


    xbTestFrame.prototype.evaluate = evaluate;
    function evaluate(deep, topNode)
    {
      if (!topNode) topNode = null;  
      _evaluate(this, deep, topNode);
    }
    
    function _evaluate(node, deep, topNode)
    {
      var eError;
      var i;
      var parentName;
      var parentObject;
        
      try
      {
        if (node.nodeName == '')
          ;
        else if (node.parentNode && typeof(node.parentNode.nameEval) != 'undefined' && node.parentNode.nameEval == null)
          node.nameExists = undefined;
        else
        {
          parentName = node.parentNode.getQualifiedName(topNode);
          if (parentName == '')
            parentObject = window;
          else
            parentObject = eval(node.parentNode.getQualifiedName(topNode));
            
          if (node.nodeName in parentObject)
            node.nameExists = true;
          else
            node.nameExists = false;
            
          node.nameEval = eval(node.getQualifiedName(topNode));

        }
      }
      catch(eError)
      {
        
        if ('code' in eError)
        {
          node.nameEval = eError.name + ': ' + 'code=' + eError.code + ', result=' + eError.result + ' ' +  eError.message;
        }
        else if ('description' in eError)
        {
          node.nameEval = '';
          
          if (eError.number)
            node.nameEval = '(' + eError.number + ') : ';
            
          node.nameEval += eError.description;
        }
        else
          node.nameEval = eError;
      }
      
      if (deep)
        for (i = 0; i < node.childNodes.length; i++)
          _evaluate(node.childNodes.item(i), deep, topNode);
    }

    
    xbTestFrame.prototype.conductTests = conductTests;
    function conductTests(deep, topNode)
    {
      if (!topNode) topNode = null;  
      _conductTests(this, deep, topNode);
    }

    function _conductTests(node, deep, topNode)
    {
      var eError;
      var i;
      var child;
      var notSupportedMsg = '';
            
      try
      {
        if (node.delayedEval)
          node.evaluate(false, topNode);

        if (node.nodeName == '')
          ;
        else if (typeof(node.nameExists) != 'undefined')
        {
          if (node.nameExists)
          {
            for (i = 0; i < node.testArray.length; i++)
              node.testArray[i].test(node, topNode);
          }
          else
          {
            if (node.parentNode && node.parentNode.nameExists && node.parentNode.nameEval == null)
              notSupportedMsg = 'Parent API Name is null';
            else
              notSupportedMsg = 'Not Supported';
              
            for (i = 0; i < node.testArray.length; i++)
            {
              ++node.skipped;
              node.testArray[i].errorMsg = notSupportedMsg;
            }
          }
        }
        else
        {
          if (node.parentNode && node.parentNode.nameExists && node.parentNode.nameEval == null)
            notSupportedMsg = 'Parent API Name is null';
          else
            notSupportedMsg = 'Not Supported';
              
          for (i = 0; i < node.testArray.length; i++)
          {
            ++node.skipped;
            node.testArray[i].errorMsg = notSupportedMsg;
          }
        }
        
        // record these test results in the api testframe
        // via the instanceOf references. 
        var instanceOf = node.instanceOf;
          
        while (instanceOf)
        {
          instanceOf.passed += node.passed;
          instanceOf.failed += node.failed;
          instanceOf.skipped += node.skipped;
          instanceOf = instanceOf.instanceOf;
        }
        
        if (deep)
        {
          for (i = 0; i < node.childNodes.length; i++)
          {
            child = node.childNodes.item(i);

            _conductTests(child, deep, topNode);
            
            node.passed += child.passed;
            node.failed += child.failed;
            node.skipped += child.skipped;
          }
        }
        
      }
      catch (eError)
      {
        var exception = new xbException('TestFrame Exception: [' + node.getQualifiedName() + ']', 'xbTestFrame.js', 'xbTestFrame::conductTests', eError);
        throw (exception);
      }

    }
    
    xbTestFrame.prototype.insert  = insert;
    function insert(sName, feature, version, docRef)
    {
      var aQnames;
      var aQparnames;
      var sParentName;
      var oParent;
      var oChild;
      var eError;
      
      if (!sName)  return null;
      
      if (!feature) feature = this.feature;
      if (!version) version = this.version;
      if (!docRef)  docRef = this.docRef;
      
      try
      {
        oChild = this.find(sName);
        oChild.feature = feature;
        oChild.version = version;
        oChild.docRef = docRef;
        return oChild;
      }
      catch(eError)
      {
        aQnames = sName.split('.');
        if (aQnames.length < 2)
        {
          oChild = new xbTestFrame(aQnames[aQnames.length-1], feature, version, docRef, this.delayedEval);
          this.appendChild(oChild);
        }
        else
        {
          aQparnames  = aQnames.slice(0, aQnames.length - 1);
          sParentName = aQparnames.join('.');
          
          try
          {
            oParent     = this.find(sParentName);
          }
          catch(eError)
          {
            oParent = this.insert(sParentName);
          }

          oChild = new xbTestFrame(aQnames[aQnames.length-1], feature, version, docRef, this.delayedEval);
          oParent.appendChild(oChild);
        }
      }
      return oChild;
    }

    xbTestFrame.prototype.append  = append;
    function append(sName, feature, version, docRef)
    {
      var aQnames;
      var aQparnames;
      var sParentName;
      var oParent;
      var oChild;
      
      if (!sName)  return null;
      
      if (!feature) feature = this.feature;
      if (!version) version = this.version;
      if (!docRef)  docRef = this.docRef;
      
      aQnames = sName.split('.');
      if (aQnames.length < 2)
      {
        oChild = new xbTestFrame(aQnames[aQnames.length-1], feature, version, docRef, this.delayedEval);
        this.appendChild(oChild);
      }
      else
      {
        aQparnames  = aQnames.slice(0, aQnames.length - 1);
        sParentName = aQparnames.join('.');
          
        oParent = this.append(sParentName);

        oChild = new xbTestFrame(aQnames[aQnames.length-1], feature, version, docRef, this.delayedEval);
        oParent.appendChild(oChild);
      }
      return oChild;
    }
    
    
    xbTestFrame.prototype.addTest = addTest;
    function addTest(testType, preCondition, actualExpr, expectedExpr, comment, number)
    {
      if (!number)
        number = this.testArray.length;
        
      if (!comment)
        comment = '';
        
      this.testArray[this.testArray.length] = new xbTestData(testType, preCondition, actualExpr, expectedExpr, comment, number);
    }

    xbTestFrame.prototype.addTestData = addTestData;
    function addTestData(testData)
    {
      this.testArray[this.testArray.length] = testData.clone();
    }
    
    
    xbTestFrame.prototype.insertTree = insertTree; 
    function insertTree(testFrame)
    {
      var i;

      if (testFrame.nodeName == '')
      {
        for (i = 0; i < testFrame.childNodes.length; i++)
          this.insertTree(testFrame.childNodes.item(i));
      }
      else
      {
        var oChild = this.appendChild(testFrame.clone());
        oChild.delayedEval = this.delayedEval;
        
        for (i = 0; i < testFrame.childNodes.length; i++)
          oChild.insertTree(testFrame.childNodes.item(i));
      }
    }
    
    // inherit copies the tests from testFrame to this node
    // then appends each of the subtrees from testFrame
    // to this node.  It maintains the testFrame's testInstances
    // and this' instanceOf references to show inheritance
    // of API nodes.
    //
    // nonlocal is used to determine which API node this becomes
    // and instance of.  this is used when mutant api testframes 
    // inherit from invariant testframes and we want to inherit
    // from the mutant but point back to the invariant... if that
    // makes sense you need medication!
    xbTestFrame.prototype.inherit = inherit;
    function inherit(testFrame, nonlocal)
    {
      var i;
      
      if (!nonlocal) nonlocal = false;
      
      for (i = 0; i < testFrame.testArray.length; i++)
        this.addTestData(testFrame.testArray[i].clone());

      this._inherit(testFrame, nonlocal);
    }

    xbTestFrame.prototype._inherit = _inherit;
    function _inherit(testFrame, nonlocal)
    {
      var eError;
      var i;
      var child;
      var testFrameChild

      if (!this.feature) this.feature = testFrame.feature;
      if (!this.version) this.version = testFrame.version;
      if (!this.docRef)  this.docRef = testFrame.docRef;
      
      // nonlocal == false -> use testFrame as instanceOf
      // nonlocal == true  -> use testFrame's instanceOf
      this.instanceOf = testFrame;
      if (nonlocal && testFrame.instanceOf)
        this.instanceOf = testFrame.instanceOf;

      if (!this.instanceOf.testInstances)
        this.instanceOf.testInstances = new Array();
      this.instanceOf.testInstances[this.instanceOf.testInstances.length] = this;
      
      for (i = 0; i < testFrame.childNodes.length; i++)
      {
        testFrameChild = testFrame.childNodes.item(i);
        // allow inheritance into subtrees with existing nodes...
        try
        {  
          child = this.find(testFrameChild.nodeName);
        }
        catch(eError)
        {
          child = this.appendChild(testFrameChild.clone());  
          child.delayedEval = this.delayedEval;
        }
        child._inherit(testFrameChild, nonlocal);
      }
    }

    xbTestFrame.prototype.distinctInherit = distinctInherit;
    function distinctInherit(testFrame, nonlocal)
    {
      var i;
      
      if (!nonlocal) nonlocal = false;
      
      for (i = 0; i < testFrame.testArray.length; i++)
        this.addTestData(testFrame.testArray[i].clone());

      this._distinctInherit(testFrame, nonlocal);
    }

    xbTestFrame.prototype._distinctInherit = _distinctInherit;
    function _distinctInherit(testFrame, nonlocal)
    {
      var i;
      var child;
      var testFrameChild

      if (!this.feature) this.feature = testFrame.feature;
      if (!this.version) this.version = testFrame.version;
      if (!this.docRef)  this.docRef = testFrame.docRef;
      
      // nonlocal == false -> use testFrame as instanceOf
      // nonlocal == true  -> use testFrame's instanceOf
      this.instanceOf = testFrame;
      if (nonlocal && testFrame.instanceOf)
        this.instanceOf = testFrame.instanceOf;

      if (!this.instanceOf.testInstances)
        this.instanceOf.testInstances = new Array();
      this.instanceOf.testInstances[this.instanceOf.testInstances.length] = this;
      
      for (i = 0; i < testFrame.childNodes.length; i++)
      {
        testFrameChild = testFrame.childNodes.item(i);

        // create separate inheritances
        child = this.appendChild(testFrameChild.clone());  
        child.delayedEval = this.delayedEval;

        child._distinctInherit(testFrameChild, nonlocal);
      }
    }
    
    xbTestFrame.prototype.find = find;
    function find(sName)
    {
      var aQnames;
      var oSymbol = null;
      var i;
      
      if (!sName)
        return null;
        
      aQnames = sName.split('.');
      
      for (i = 0; i < this.childNodes.length; i++)
      {
        oSymbol = _findChildNode(this.childNodes.item(i), aQnames);
        if (oSymbol)
          break;
      }
      
      if (oSymbol == null)
        throw (new xbException('NOT FOUND ERR: Context [' + this.getQualifiedName(this) + ' : ' + sName + ']', 
                    'xbTestFrame.js', 
                    'xbTestFrame::find'));
      
      return oSymbol;
    }

    function _findChildNode(testFrame, aQnames)
    {
      if (aQnames.length == 0)
        return null;
        
      if (aQnames[0] != testFrame.nodeName)
        return null;

      if (aQnames.length == 1)
        return testFrame;
        
      var i;
      var oSymbol    = null;
      var aQsubnames = aQnames.slice(1);
      
      for (i = 0; i < testFrame.childNodes.length; i++)
      {
        oSymbol = _findChildNode(testFrame.childNodes.item(i), aQsubnames);
        if (oSymbol != null)
          break;
      }
      return oSymbol;
    }
    
    xbTestFrame.prototype.remove  = remove;
    function remove(sName)
    {
      var oParent;
      var oChild;
      var eError;
      
      if (!sName)
        return null;
        
      try
      {
        oChild = this.find(sName);
      }
      catch(eError)
      {
        return null;
      }
        
      oParent = oChild.parentNode;
      
      if (oParent ==  null)
        throw(new xbException('can not remove root', 'TestFrame.js', 'remove'));
      else
        oParent.removeChild(oChild);
        
      return oChild;
    }
    
    
    // prune is intended to be called after a particular
    // instance test is completed. 
    xbTestFrame.prototype.prune = prune;
    function prune(removeAll)
    {
      var currChild;
      var nextChild;
      var tempArray;
      var i;
      
      if (!removeAll) removeAll = false;

      currChild = this.firstChild;
      while (currChild)
      {
        // save next child since currChild may be deleted by prune...
        nextChild = currChild.nextSibling
        currChild.prune(removeAll);
        currChild = nextChild;
      }

      tempArray    = this.testArray;
      this.testArray  = new Array();
        
      for (i = 0; i < tempArray.length; i++)
      {
        if (tempArray[i].tested)
          this.testArray[this.testArray.length] = tempArray[i];
        else
        {
          tempArray[i].destroy();
          tempArray[i] = null;
        }
      }
      
      if (removeAll && this.passed + this.failed == 0)
      {
        if (this.instanceOf)
        {
          tempArray = this.instanceOf.testInstances;
          this.instanceOf.testInstances = new Array();
            
          for (i = 0; i < tempArray.length; i++)
          {
            if (tempArray[i] != this)
              this.instanceOf.testInstances[this.instanceOf.testInstances.length] = tempArray[i];
          }
        }
        
        if (this.parentNode)
          this.parentNode.removeChild(this);
          
        this.destroy();
        
        return null;
      }
      
      return this;
    }
    
    function _nodeCompare(l, r)
    {
      if (l.nodeName < r.nodeName)
        return -1;
        
      if (l.nodeName > r.nodeName)
        return +1;
        
      return 0;
    }
    
    xbTestFrame.prototype.sortChildren = sortChildren;
    function sortChildren()
    {
      var i;
      
      this.sorted = true;
      
      this.childNodes.sort(_nodeCompare);
    }

    xbTestFrame.prototype.writeEvaluationReport  = writeEvaluationReport;
    function writeEvaluationReport(deep, topNode)
    {
      var eError;
      var lines = new Array();
      
      if (!topNode) topNode = null;  
    
      try
      {
        lines[lines.length] = '<table border="1" bordercolor="black" cellpadding="3" cellspacing="0" width="90%">';
        lines[lines.length] = '<tr>';
        lines[lines.length] = '<td><b>Item</b></td>';
        lines[lines.length] = '<td><b>Feature Version</b></td>';
        lines[lines.length] = '<td><b>Evaluates to</b></td>';
        lines[lines.length] = '<td><b>Exists</b></td>';
        lines[lines.length] = '</tr>';

        _evaluationReport(this, deep, topNode, lines);

        lines[lines.length] = '</table>';
        
        return lines.join(' ');
      }
      catch (eError)
      {
        var exception = new xbException('TestFrame Error', 'xbTestFrame.js', 'xbTestFrame::evaluationReport', eError);
        throw exception;
      }
      
      return '';
    }
    
    function _evaluationReport(node, deep, topNode, lines)
    {
      var eError;
      var i;
      var sExistsColor;
      var sNameColor;
      var sNameEval;

      try
      {
        if (!node.sorted)
          node.sortChildren();
          
        if (node.nodeName != '')
        {
          if (typeof(node.nameExists) == 'undefined')
            sExistsColor = 'black';
          else
            sExistsColor = node.nameExists ? 'green' : 'red';
            
          sNameColor = sExistsColor;
          
          sNameEval = node.nameEval;
          if (typeof(sNameEval) == 'string')
          {
            if (sNameEval == '')
              if (node.nameExists)
                sNameEval = '""';
              else
                sNameEval = '&nbsp;'
          }
          
          lines[lines.length] = '<tr>';
          lines[lines.length] = '<td><font color="' + sNameColor      + '">' + node.getQualifiedName(topNode) + '</font></td>';
          lines[lines.length] = '<td>' + node.feature   + ' ' + node.version + '</td>';
          lines[lines.length] = '<td>';
          
          if (typeof(sNameEval) == 'string')
          {
            sNameEval = sNameEval.replace(/</g, '&lt;');
            sNameEval = sNameEval.replace(/>/g, '&gt;');
          }
          
          lines[lines.length] = sNameEval + '';
          lines[lines.length] = '</td>';
          lines[lines.length] = '<td><font color="' + sExistsColor + '">' + node.nameExists + '</font></td>';
          lines[lines.length] = '</tr>';
        }

        if (deep)
          for (i = 0; i < node.childNodes.length; i++)
             _evaluationReport(node.childNodes.item(i), deep, topNode, lines)

      }
      catch (eError)
      {
        var exception = new xbException('TestFrame Error', 'xbTestFrame.js', 'xbTestFrame::_evaluationReport', eError);
        throw exception;
      }
      
      return;
    }
    
    xbTestFrame.prototype.writeTestReport = writeTestReport;
    function writeTestReport(deep, topNode)
    {
      var lines = new Array();
      
      if (!topNode) topNode = null;

      lines[lines.length] = '<table border="1" cellpadding="5" cellspacing="0" width="90%">';
      
      _testReport(this, deep, topNode, lines);
      
      lines[lines.length] = '</table>';
      
      return lines.join(' ');
    }
    
    function _testReport(node, deep, topNode, lines)
    {
      var eError;
      var i;
      var nPassed;
      var sNameColor;
      var sResultColor;
      var sName;
      var sParentName;
      
      try
      {
        // Do not sort the test report since sorting loses
        // information about the order the tests were performed.
        //if (!node.sorted)
        //  node.sortChildren();
            
        if (node.nodeName != '')
        {
          nPassed      = 0;
          sNameColor    = '';
          sResultColor  = '';
          sName      = node.getQualifiedName(topNode);
          sParentName    = node.parentNode == null ? '' : node.parentNode.getQualifiedName(topNode);

          if (node.parentNode && node.parentNode.nameExists && !node.parentNode.nameEval)
            // parent name exists but has no value, don't mark red
            sNameColor = 'black';
          else if (typeof(node.nameExists) == 'undefined')
            sNameColor = 'red';
          else if (!node.nameExists)
            sNameColor = 'red';
          else if (node.passed + node.failed == 0)
            sNameColor = 'black';
          else if (node.failed == 0)
            sNameColor = 'green';
          else if (node.passed == 0)
            sNameColor = 'red';
          else
            sNameColor = 'purple';

          // mozilla not displaying background color on row correctly
          // when setting via tr, so using td instead!
          lines[lines.length] = '<tr>';
          lines[lines.length] = '<td bgcolor="skyblue" colspan="1"><b><font color="' + sNameColor + '">' + sName + '</font></b></td>';
          lines[lines.length] = '<td bgcolor="skyblue" colspan="1">' + node.feature + '&nbsp;' + node.version + '</td>';
          lines[lines.length] = '<td bgcolor="skyblue" colspan="3">' + node.passed + ' passed, ' + node.failed + ' failed, ' + node.skipped + ' skipped out of ' + (node.passed + node.failed + node.skipped) + ' tests</td>';
          lines[lines.length] = '</tr>';

          if (node.testArray.length > 0)
          {
            lines[lines.length] = '<tr>';
            
            lines[lines.length] = '<td>';
            if (node.docRef)
              lines[lines.length] = 'See ' + node.docRef
            else
              lines[lines.length] = '&nbsp;';
            lines[lines.length] = '</td>';
            
            lines[lines.length] = '<td><b>Expected</b></td>';
            lines[lines.length] = '<td><b>Actual</b></td>';
            lines[lines.length] = '<td><b>Result</b></td>';
            lines[lines.length] = '<td><b>Error Message</b></td>';
            lines[lines.length] = '</tr>';
            
            for (i = 0; i < node.testArray.length; i++)
            {
              var testData = node.testArray[i];
              
              if (!testData.tested)
                sResultColor = 'black';
              else if (testData.testPassed)
                sResultColor = 'green';
              else
                sResultColor = 'red';
                    
              var actualExpr    = node.replaceParms(testData.actualExpr, topNode);     
              var expectedExpr  = node.replaceParms(testData.expectedExpr, topNode);
              var preConditionExpr  = node.replaceParms(testData.preCondition, topNode);

              var errorMsg = testData.errorMsg;
              if (errorMsg == '')
                errorMsg = '&nbsp;';
                    
              var actualValue = testData.actualValue;
              if (typeof(actualValue) == 'string')
              {
                if (actualValue == '')
                  actualValue = '""';
                else
                {
                  actualValue = actualValue.replace(/</g, '&lt;');
                  actualValue = actualValue.replace(/>/g, '&gt;');
                }
              }
              var expectedValue = testData.expectedValue;
              if (typeof(expectedValue) == 'string')
              {
                if (expectedValue == '')
                  expectedValue = '""';
                else
                {
                  expectedValue = expectedValue.replace(/</g, '&lt;');
                  expectedValue = expectedValue.replace(/>/g, '&gt;');
                }
              }
              
              if (testData.comment != '' || preConditionExpr != '')
              {
                lines[lines.length] = '<tr>';
                lines[lines.length] = '<td colspan="5"><i>';
                lines[lines.length] = testData.comment;
                lines[lines.length] = '</i><br>';
                lines[lines.length] = 'Test when: <code>' + preConditionExpr + '</code>';
                lines[lines.length] = '</td>';
                lines[lines.length] = '</tr>';
              }

              lines[lines.length] = '<tr>';
              lines[lines.length] = '<td>';
              lines[lines.length] = '<font color="' + sResultColor + '">';
              lines[lines.length] = '#' + testData.number + ': ';
              lines[lines.length] =  (testData.testType == 'EQ' ? 'Equality' : 'Exception') + ' ';
              lines[lines.length] =  'Expression <code>' + actualExpr + '</code> ';
              lines[lines.length] =  'Expect <code>' + expectedExpr + '</code>';
              lines[lines.length] = '</font>';
              lines[lines.length] = '</td>';
              lines[lines.length] = '<td>' + expectedValue + '</td>';
              lines[lines.length] = '<td>' + actualValue + '</td>';
              lines[lines.length] = '<td>';
              
              if (!testData.tested)
                lines[lines.length] = '&nbsp;';
              else if (testData.testPassed)
                lines[lines.length] = 'passed';
              else
                lines[lines.length] = 'failed';
                  
              lines[lines.length] = '</td>';
              lines[lines.length] = '<td>' + errorMsg + '</td>';
              lines[lines.length] = '</tr>';
            }
          }
        }
      
        if (deep)
          for (i = 0; i < node.childNodes.length; i++)
            _testReport(node.childNodes.item(i), deep, topNode, lines);
      }
      catch (eError)
      {
        var exception = new xbException('TestFrame Error', 'xbTestFrame.js', 'xbTestFrame::_testReport', eError);
        throw exception;
      }
                
      return;
    }
  }
}

// eof: xbTestFrame.js
