/*
 * $Id: xbTreeWidgetStatic.js,v 1.7 2003/09/14 21:22:27 bc Exp $
 *
 */

/* ***** BEGIN LICENSE BLOCK *****
 * The contents of this file are subject to the Mozilla Public License Version 
 * 1.1 (the "License"); you may not use this file except in compliance with 
 * the License. You may obtain a copy of the License at 
 * http://www.mozilla.org/MPL/
 * 
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 * 
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Netscape code.
 *
 * The Initial Developer of the Original Code is
 * Netscape Corporation.
 * Portions created by the Initial Developer are Copyright (C) 2001
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Bob Clary <bclary@netscape.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 * 
 ***** END LICENSE BLOCK ***** */

xbDEBUG.on = false;

xbTreeWidgetStatic._id = 0;
xbTreeWidgetStatic._hash = new Object();
xbTreeWidgetStatic._dynamic = (document.documentElement && typeof(document.documentElement.innerHTML) == 'string');

function xbTreeWidgetStatic(handles, labels, classprefix )
{
  this.id = 'treewidgetid' + xbTreeWidgetStatic._id++;
  xbTreeWidgetStatic._hash[this.id] = this;
  this.handles      = handles;
  this.labels       = labels;
  this.classprefix  = classprefix ? classprefix : 'treewidget';
  this.children     = new Array();
}

xbTreeWidgetStatic.prototype.appendChild =
function xbTreeNodeAppendChild(child)
{
  if (child)
    this.children[this.children.length] = child;
  return child;
}

if (document.getElementById || document.all)
{
  xbTreeWidgetStatic.prototype.toHTML =
  function xbTreeWidgetStaticToHTMLDOMIE(level)
  {
    var i;
    var html = '';

    if (typeof(level) == 'undefined')
      level = 0;

    html += '<div class="' + this.classprefix + 'container">\n';

    html += '<div ID="' + this.id + '" class="' + this.classprefix + 'handle" onclick="xbTreeWidgetStaticToggleHandle(this)">';
    if (xbTreeWidgetStatic._dynamic  && level > 0 && this.children.length > 0)
    {
      html += this.handles.closed;
      html += this.labels.closed;
    }
    else
    {
      html += this.handles.open;
      html += this.labels.open;
    }
    html += '<\/div>\n';

    if (this.children.length)
    {
      html += '<div class="' + this.classprefix + 'children" ';

      if (xbTreeWidgetStatic._dynamic  && level > 0)
      {
        html += 'style="display:none;">';
      }
      else
      {
        html += 'style="display:block;">';
      }

      for (i = 0; i < this.children.length; i++)
      {
        html += this.children[i].toHTML(level + 1);
      }

      html += '<\/div>\n';
    }

    html += '<\/div>\n';

    //alert(html);
    return html;
  };
}
else 
{
  xbTreeWidgetStatic.prototype.toHTML =
  function xbTreeWidgeToHTMLLegacy(depth)
  {
    var i;
    var html = '';

    if (typeof(depth) == 'undefined')
    {
      depth = 0;
    }

    html += '<table>\n';
    html += '<tr>\n';
    html += '<td>\n';

    if (document.layers)
      html += '<ilayer visibility="hidden">\n';
    else
      html += '<span style="visibility: hidden">\n';

    for (i = 0; i < depth; i++)
    {
      html += '..';
    }

    if (document.layers)
      html += '<\/ilayer>\n';
    else
      html += '<\/span>\n';

      html += this.handles.open + this.labels.open;

    for (i = 0; i < this.children.length; i++)
    {
      html += this.children[i].toHTML(depth+1);
    }

    html += '<\/td>\n';
    html += '<\/tr>\n';
    html += '<\/table>\n';

    return html;
  };
}

function xbGetNextElement(node)
{
  var next;

  for (next = node.nextSibling; next; next = next.nextSibling)
  {
    if (next.nodeType == 1)
      return next;
  }
  
  return null;
}

function xbTreeWidgetStaticToggleHandle(handlediv)
{
  if (!handlediv)
    return false;

  var widget;

  var next = xbGetNextElement(handlediv);
  if (next)
  {
    switch(next.style.display)
    {
      case '':
      case 'block':
        next.style.display = 'none';
        if (typeof(handlediv.innerHTML) == 'string')
        {
          widget = xbTreeWidgetStatic._hash[handlediv.id];
          handlediv.innerHTML = widget.handles.closed + widget.labels.closed;
        }
        break;
      case 'none':
        next.style.display = 'block';
        if (typeof(handlediv.innerHTML) == 'string')
        {
          widget = xbTreeWidgetStatic._hash[handlediv.id];
          handlediv.innerHTML = widget.handles.open + widget.labels.open;
        }
        break;
      default:
        return false;
     }
   }
   return true;
}

function xbCreateTreeWidgetStaticFromObject(getChildren, getHandles, getLabels, obj, classprefix)
{
  xbDEBUG.dump('xbCreateStaticTreeWidgetFromObject()');

  var i;
  var children;
  var root = null;
  var handles = getHandles(obj, classprefix);
  var labels = getLabels(obj, classprefix);

  children = getChildren(obj);
  root = new xbTreeWidgetStatic(handles, labels, classprefix);

  for (i = 0; i < children.length; i++)
  {
    var child = children[i];
    root.appendChild( xbCreateTreeWidgetStaticFromObject(getChildren, getHandles, getLabels, child, classprefix) );
  }

  return root;
}

