/*
 * $Id: xbUtils.js,v 1.7 2003/09/14 21:22:27 bc Exp $
 *
 */

// Miscellaneous utilities

/* ***** BEGIN LICENSE BLOCK *****
 * The contents of this file are subject to the Mozilla Public License Version 
 * 1.1 (the "License"); you may not use this file except in compliance with 
 * the License. You may obtain a copy of the License at 
 * http://www.mozilla.org/MPL/
 * 
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 * 
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Bob Clary code.
 *
 * The Initial Developer of the Original Code is
 * Bob Clary.
 * Portions created by the Initial Developer are Copyright (C) 2000
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Bob Clary <http://bclary.com/>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 * 
 ***** END LICENSE BLOCK ***** */

function Contains(eOuter, eInner)
{
  var i;
  var result = false;
  
  if (!eOuter || !eInner)
    result = false;
  else if (eOuter == eInner)
    result = true;
  else
    for (i = 0; i < eOuter.childNodes.length; i++)
      if (Contains(eOuter.childNodes.item(i), eInner))
      {
        result = true;
        break;
      }
      
  //writeLogWindow('Contains(' + eOuter.nodeName + ':' + eOuter.getAttribute('id') + ', ' + eInner.nodeName + ':' + eInner.getAttribute('id') + ')==' + result );

  return result;
}

// dom core does not have this function
function GetElementById(This, elementId)
{
  var id = This.getAttribute('id');
  
  if (id == elementId)
    return This;
        
  var element = null;
  var node = null;
  var i;
      
  for (i = 0; i < This.childNodes.length; i++)
  {
    node = This.childNodes.item(i);
    // HACK: 
    var nodeType = 0;
    if (typeof(node.nodeType) != 'undefined')
      nodeType = node.nodeType;
    else if (typeof(node.getNodeType) != 'undefined')
      nodeType = node.getNodeType();

    if (nodeType == 1)
    {
      element = GetElementById(node, elementId);
      if (element != null)
        break;
    }
  }
  return element;
}

// getPosition returns object with left, top properties
// that correspond to the offsets from the offsetParent root
// of the page... typically BODY.
// this means it is the left,top coordinate of the the bounding
// box consisting of the margin, border, padding and content.
// 
// note IE places offsetLeft,offsetTop at the upper left corner of
// the border, while Mozilla places it at the upper left corder of 
// the padding.

// the following assumes all units are in px

function getPosition(elm)
{
  if (!elm)
    return null;

  var pos = new Object();
  
  pos.left = 0;
  pos.top  = 0;

  while (elm && /* fix for HTML.offsetParent */ elm != document.body.offsetParent)
  {
    if (elm.nodeType == 1)
    {
      if (navigator.family == 'ie4' && navigator.version >= 5)
      {
        if (elm.style.left)
          pos.left += stringToInteger(elm.style.left);
        else
          pos.left += elm.offsetLeft - stringToInteger(elm.style.marginLeftWidth);
          
        if (elm.style.top)
          pos.top += stringToInteger(elm.style.top);
        else
          pos.top  += elm.offsetTop - stringToInteger(elm.style.marginTopWidth);
      }
      else
      {
        if (elm.style.left)
          pos.left += stringToInteger(elm.style.left);
        else
          pos.left += elm.offsetLeft - stringToInteger(elm.style.marginLeftWidth) - stringToInteger(elm.style.borderLeftWidth);

        if (elm.style.top)
          pos.top += stringToInteger(elm.style.top);
        else
          pos.top += elm.offsetTop - stringToInteger(elm.style.marginTopWidth) - stringToInteger(elm.style.borderTopWidth);
          
      }
    }
    elm = elm.offsetParent;
  }
  return pos;
}

function setPosition(elm, left, top)
{
  var parentPosition;
  
  if (!elm)
    throw(new xbException('Element can not be null', 'xbUtils.js', 'setPosition'));
    
  if (elm.nodeType != 1)
    throw(new xbException('Must be an Element', 'xbUtils.js', 'setPosition'));
    
  if (elm == document.body)
    throw(new xbException('Body Element not positionable', 'xbUtils.js', 'setPosition'));

  if (elm.offsetParent != null)
  {
    parentPosition = getPosition(elm.offsetParent);

    left -= parentPosition.left;
    top  -= parentPosition.top;
  }

  elm.style.left = left;
  elm.style.top  = top;
}

function getBoundary(elm)
{
  var boundary = new Object();
  if (elm.nodeType != 1)
    elm = elm.parentNode;
    
  var Style = elm.style;
    
  var pos = getPosition(elm);
    
  boundary.left   = pos.left;
  boundary.top    = pos.top;
  boundary.right  = pos.left + stringToInteger(elm.style.marginLeft) + elm.offsetWidth  + stringToInteger(elm.style.marginRight);
  boundary.bottom = pos.top  + stringToInteger(elm.style.marginTop)  + elm.offsetHeight + stringToInteger(elm.style.marginBottom);

  return boundary;
}

function getEventPosition(evt)
{
  var eventPos;
  
  if (evt.target.nodeType == 1)
    eventPos = getPosition(evt.target.offsetParent);
  else
    eventPos = getPosition(evt.target.parentNode);
  
  if (eventPos != null)
  {
    eventPos.left += evt.clientX;
    eventPos.top  += evt.clientY;
  }
  else
  {
    eventPos = new Object();
    eventPos.left = 0;
    eventPos.top = 0;
  }

  return eventPos;
}  
  
function ElementContainsEvent(elm, evt)
{
  var i;
  var result   = null;
  var boundary = getBoundary(elm);
  //var eventPos = getEventPosition(evt);

  
  if (!elm || !evt)
    result = null;
  else if (elm.nodeType != 1)
    result = null;
  else if (evt.clientX < boundary.left || evt.clientX > boundary.right  || evt.clientY < boundary.top || evt.clientY > boundary.bottom)
    result = null;
  else
  {
    for (i = 0; i < elm.childNodes.length; i++)
    {
      if (elm.nodeType == 1)
        result = ElementContainsEvent(elm.childNodes.item(i), evt);
      
      if (result != null)
        break;
    }
    
    if (result == null)
      result = elm;
  }
      
  return result;
}  

function ElementContainsPoint(elm, left, top)
{
  var i;
  var result   = null;
  var boundary = getBoundary(elm);
  
  if (!elm)
    result = null;
  else if (elm.nodeType != 1)
    result = null;
  else if (left < boundary.left || left > boundary.right  || top < boundary.top || top > boundary.bottom)
    result = null;
  else
  {
    for (i = 0; i < elm.childNodes.length; i++)
    {
      if (elm.nodeType == 1)
        result = ElementContainsPoint(elm.childNodes.item(i), left, top);
      
      if (result != null)
        break;
    }
    
    if (result == null)
      result = elm;
  }
      
  return result;
}  




//</script>
