/*
 * $Id: xbWindow.js,v 1.7 2003/09/14 21:22:27 bc Exp $
 *
 */

// emulate window.open with an onload handler

/* ***** BEGIN LICENSE BLOCK *****
 * The contents of this file are subject to the Mozilla Public License Version 
 * 1.1 (the "License"); you may not use this file except in compliance with 
 * the License. You may obtain a copy of the License at 
 * http://www.mozilla.org/MPL/
 * 
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 * 
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Bob Clary code.
 *
 * The Initial Developer of the Original Code is
 * Bob Clary.
 * Portions created by the Initial Developer are Copyright (C) 2000
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Bob Clary <http://bclary.com/>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 * 
 ***** END LICENSE BLOCK ***** */

/*
windowRef = xbWindowOpen(url, windowName, windowFeatures, windowOnload);

windowRef       reference to opened window 
  
url             url of file to be read
windowName      name of window to be opened
windowFeatures  feature string for window
windowOnload    reference to onload handler function

based upon original FileReader.js

2001-06-29: bclary separated out windowOnLoad for reusability
2001-07-07: bclary reworked and renamed to use new xbAsyncOnload hander

*/

function xbWindowOpen(url, windowName, windowFeatures, windowOnload)
{
  xbDEBUG.dump('xbWindowOpen');

  var windowRef;
  
  if (!windowName)
    windowName = undefined;
    
  if (!windowFeatures)
    windowFeatures = undefined;
     
  windowRef = window.open(url, windowName, windowFeatures);

  xbAsyncOnloadHandler(windowRef.document, windowOnload, windowInvariant);
  
  return windowRef;
}

function xbFrameOnload(frameElement, frameOnload)
{
  xbDEBUG.dump('xbFrameOnload');

  xbAsyncOnloadHandler(getFrameDocument(frameElement), frameOnload, windowInvariant);
}

function windowInvariant(documentRef)
{
  xbDEBUG.dump('windowInvariant');

  if (!documentRef)
    throw('windowInvariant: documentRef is null or undefined');
    
  var e;
  if (navigator.product == 'Gecko' && !sameDomain(documentRef.window))
    try
    {
      netscape.security.PrivilegeManager.enablePrivilege("UniversalBrowserRead UniversalBrowserWrite");
    }
    catch(e)
    {
      throw e;
    }
  
  try 
  { 
    return documentRef.getElementsByTagName('*').length;
  }
  catch (e) 
  {
    xbDEBUG.dump('windowInvariant: Error');
  }
  
  return (new Date()).getTime();
}  
